//
//  AllpriceTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AllpriceTableViewCell.h"

@implementation AllpriceTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

#pragma mark -赋值
- (void)setGoodsAllprice:(NSArray *)goodsAllprice
{
    _goodsAllprice = goodsAllprice;
    NSUInteger allNumber = 0;
    CGFloat allPrice = 0;
    for (ShopcarModel *model in _goodsAllprice) {
        allNumber += model.goodsNum;
        allPrice += [model.costPrice floatValue] *model.goodsNum;
    }
    self.goodsAllPrice.text = [NSString stringWithFormat:@"￥%.2f",allPrice];
}


#pragma mark -数据源赋值
- (void)setGoodsArray:(NSArray *)goodsArray
{
    _goodsArray = goodsArray;
    NSInteger allNumber = 0;//总数量
    CGFloat allPrice = 0;//总价格
    CGFloat newPrice = 0;//折后价格
    CGFloat deductionPrice = 0;//抵扣金额
    for (TOOrderdetailEntity *model in _goodsArray) {
        allNumber += [model.goodsNum integerValue];
        allPrice += [model.goodsPrice floatValue]*[model.goodsNum intValue];
    }
    newPrice = allPrice;
    /// 抽奖折扣
    if ([self.model.number length]) {
        newPrice = allPrice * ([self.model.number integerValue]/100.0);
    }
    /// 全局抵扣
    if (self.promotionalArray) {
        for (id object in self.promotionalArray) {
            if ([object isKindOfClass:[PromotionalDeductionModel class]]) {
                PromotionalDeductionModel *model = (PromotionalDeductionModel *)object;
                if ([model.type isEqualToString:@"deductionAction"]) {
                    deductionPrice = model.total;
                }
            }
        }
    }
    NSString *goodsAllPriceString = nil;
    if (deductionPrice && newPrice != allPrice) {
        goodsAllPriceString = [NSString stringWithFormat:@"￥%.2f  (%.2f x %@ - %.2f)",newPrice-deductionPrice,allPrice,self.model.descriptionString,deductionPrice];
        
    }else if (newPrice == allPrice && !deductionPrice){
        goodsAllPriceString = [NSString stringWithFormat:@"￥%.2f",newPrice];
        
    }else if (newPrice == allPrice && deductionPrice){
        goodsAllPriceString = [NSString stringWithFormat:@"￥%.2f  (%.2f - %.2f)",newPrice-deductionPrice,allPrice,deductionPrice];

    }else if (newPrice != allPrice && !deductionPrice){
        goodsAllPriceString = [NSString stringWithFormat:@"￥%.2f  (%.2f x %@)",newPrice-deductionPrice,allPrice,self.model.descriptionString];
    }
    self.goodsAllNumber.text = [NSString stringWithFormat:@"%ld",allNumber];
    self.goodsAllPrice.text = goodsAllPriceString;
}






- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
