//
//  NetworkRequestClassManager.h
//  Lighting
//
//  Created by 曹云霄 on 16/4/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "opple_objc_json_client.h"

//定义返回数据的block类型
typedef void (^ReturnValueBlock) (id returnValue);
typedef void (^FailureBlock)(NSError *error);

//上传图片返回当前进度
typedef void (^UploadprogressBlock)(double progress);

//定义请求类型
typedef NS_ENUM(NSInteger,NetworkRequestType){
    POST = 0, //POST
    GET,       //GET
    NetworkRequestWithDELETE    //DELETE
};


@interface NetworkRequestClassManager : NSObject

/**
 *  网络请求单例
 *
 *  @return NetworkRequestClassManager
 */
+ (NetworkRequestClassManager *)manager;


/**
 *  网络请求传入JSONModel对象
 *
 *  @param requestURLString     网址
 *  @param requestType          请求类型
 *  @param parameter            JSONModel对象
 *  @param sueecssBlock         成功回调
 *  @param errorCodeBlock       错误编码回调
 *  @param failureBlock         失败回调
 */
- (void)networkRequestWithURL:(NSString *) requestURLString
                  withRequestType:(NetworkRequestType) requestType
                    withParameter:(JSONModel *) jastorobject
             withReturnValueBlock:(ReturnValueBlock) successBlock
                 withFailureBlock:(FailureBlock) failureBlock;


/**
 *  网络请求传入字典对象
 *
 *  @param requestURLString     网址
 *  @param requestType          请求类型
 *  @param parameter            字典对象
 *  @param sueecssBlock         成功回调
 *  @param errorCodeBlock       错误编码回调
 *  @param failureBlock         失败回调
 */
- (void)networkWithDictionaryRequestWithURL:(NSString *) requestURLString
              withRequestType:(NetworkRequestType) requestType
                withParameter:(NSDictionary *) parameter
         withReturnValueBlock:(ReturnValueBlock) successBlock
             withFailureBlock:(FailureBlock) failureBlock;

/**
 *  下载PDF
 *
 *  @param requestURLString 网址
 *  @param successBlock     成功回调
 *  @param errorCodeBlock   错误编码回到
 *  @param failureBlock     失败回调
 */
- (void)downloadPDFdatasWithURL:(NSString *) requestURLString
           withReturnValueBlock:(ReturnValueBlock) successBlock
               withFailureBlock:(FailureBlock) failureBlock;

/**
 *  上传分享图片
 *
 *  @param requestURLString 网址
 *  @param requestType      请求类型
 *  @param parameter        参数
 *  @param successBlock     成功回调
 *  @param progressBlock    上传进度
 *  @param errorCodeBlock   错误编码回调
 *  @param failureBlock     失败回调
 */

- (void)uploadImageWithURL:(NSString *) requestURLString
           withRequestType:(NetworkRequestType) requestType
            withImageDatas:(NSData *) imagedata
             withParameter:(NSDictionary *) parameter
      withReturnValueBlock:(ReturnValueBlock) successBlock
         withprogressBlock:(UploadprogressBlock) progressBlock
          withFailureBlock:(FailureBlock) failureBlock;





















@end
