//
//  UIView+Frame.h
//  Lighting
//
//  Created by 曹云霄 on 16/4/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIView (Frame)


// 分类不能添加成员属性
// @property如果在分类里面，只会自动生成get,set方法的声明，不会生成成员属性，和方法的实现
@property (nonatomic, assign) CGFloat x;
@property (nonatomic, assign) CGFloat y;
@property (nonatomic, assign) CGFloat width;
@property (nonatomic, assign) CGFloat height;

/**
 设置圆角

 @param number 圆角系数
 */
- (void)setMyCorner:(CGFloat)number;
/**
 *  获取view父视图的控制器
 *
 *  @return 控制器
 */
- (UIViewController *)viewController;

/**
 添加边框

 @param width 边框宽度
 */
- (void)setLinewidth:(CGFloat)width;
@end
