//
//  BindingBankCARDViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/30.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BindingBankCARDViewController.h"
#import "BindingTableViewCell.h"
#import "BindingSuccessViewController.h"
#import "MyBankClass.h"

@interface BindingBankCARDViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic,strong) NSArray *titleArray;

@end

@implementation BindingBankCARDViewController

#pragma mark - lazy
- (NSArray *)titleArray
{
    return @[@"持卡人",@"银行卡号",@"身份证号码",@"手机号码"];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTableView];
}

#pragma mark - UITableView
- (void)setUpTableView
{
    self.bindingTableView.tableFooterView = [UIView new];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    BindingTableViewCell *bindingCell = [tableView dequeueReusableCellWithIdentifier:@"BindingTableViewCell" forIndexPath:indexPath];
    bindingCell.bindingTitleLabel.text = self.titleArray[indexPath.row];
    bindingCell.bindingInputTextField.placeholder = [NSString stringWithFormat:@"请输入%@",self.titleArray[indexPath.row]];
    return bindingCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.titleArray.count;
}


#pragma mark - 验证输入信息
- (IBAction)nextButtonClickAction:(UIButton *)sender {
    
    [self validationBankCardInformationIsMatching];
}

#pragma mark - 验证银行卡信息是否匹配
- (void)validationBankCardInformationIsMatching
{
    TOCommAuthEntity *entity = [[TOCommAuthEntity alloc] init];
    BindingTableViewCell *cardholderCell = [self.bindingTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0]];
    entity.accountName = cardholderCell.bindingInputTextField.text;
    BindingTableViewCell *bankAccountCell = [self.bindingTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:1 inSection:0]];
    entity.bankAccount = bankAccountCell.bindingInputTextField.text;
    BindingTableViewCell *identityCodeCell = [self.bindingTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:2 inSection:0]];
    entity.identityCode = identityCodeCell.bindingInputTextField.text;
    BindingTableViewCell *phoneNumberCell = [self.bindingTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:3 inSection:0]];
    entity.phoneNumber = phoneNumberCell.bindingInputTextField.text;
    if ([[self class] isBlankString:entity.accountName]) {
        [XBLoadingView showHUDViewWithText:@"持卡人不能为空"]; return;
    }
    if ([[self class] isBlankString:entity.identityCode]) {
        [XBLoadingView showHUDViewWithText:@"身份证号码不能为空"]; return;
    }
    if ([[self class] isBlankString:entity.bankAccount]) {
        [XBLoadingView showHUDViewWithText:@"银行卡号不能为空"]; return;
    }
    if ([[self class] isBlankString:entity.identityCode]) {
        [XBLoadingView showHUDViewWithText:@"身份证号码不能为空"]; return;
    }
    if ([self isPureInt:entity.accountName]) {
        [XBLoadingView showHUDViewWithText:@"银行卡号格式不正确"]; return;
    }
    if (![HENLENSONG isValidateMobile:entity.phoneNumber]) {
        [XBLoadingView showHUDViewWithText:@"手机号码格式不正确"]; return;
    }
    NSString *type = [MyBankClass returnBankName:entity.bankAccount];
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];
    [HTTP networkRequestWithURL:SERVERREQUESTURL(VALIDATION) withRequestType:ZERO withParameter:entity withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if (RESULT(returnValue)) {
            [XBLoadingView showHUDViewWithSuccessText:@"验证成功" completeBlock:^{
                BindingSuccessViewController *bindingSuccess = [[[weakSelf class] getMainStoryboardClass]instantiateViewControllerWithIdentifier:@"BindingSuccessViewController"];
                bindingSuccess.bankType = type;
                bindingSuccess.bankEntity = entity;
                [weakSelf.navigationController pushViewController:bindingSuccess animated:YES];
            }];
        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    } withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 判断是否是纯数字
- (BOOL)isPureInt:(NSString*)string{
    NSScanner* scan = [NSScanner scannerWithString:string];
    int val;
    return[scan scanInt:&val] && [scan isAtEnd];
}




@end
