//
//  ApplyPrizeViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/22.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ApplyPrizeViewController.h"
#import "MOFSPickerManager.h"
@interface ApplyPrizeViewController ()<UITextFieldDelegate>


/**
 保存兑奖单
 */
@property (nonatomic,strong) RsPrizeBill *prizeBill;

@end

@implementation ApplyPrizeViewController

#pragma mark -取消弹出的圆角
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    self.view.superview.layer.cornerRadius = 0;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setUpTextFieldAction];
}

#pragma mark - 设置UITextField
- (void)setUpTextFieldAction
{
    UIView *leftView1 = [[UIView alloc]init];
    leftView1.frame = CGRectMake(0, 0, 10, 1);
    self.consigneeTextField.leftView = leftView1;
    self.consigneeTextField.leftViewMode = UITextFieldViewModeAlways;
    UIView *leftView2 = [[UIView alloc]init];
    leftView2.frame = CGRectMake(0, 0, 10, 1);
    self.mobileTextField.leftView = leftView2;
    self.mobileTextField.leftViewMode = UITextFieldViewModeAlways;
    UIView *leftView4 = [[UIView alloc]init];
    leftView4.frame = CGRectMake(0, 0, 10, 1);
    self.addressDetailsTextField.leftView = leftView4;
    self.addressDetailsTextField.leftViewMode = UITextFieldViewModeAlways;
    [self.addressButton addTarget:self action:@selector(selectedCityClickAction) forControlEvents:UIControlEventTouchUpInside];
}

#pragma mark - 选中礼品
- (void)setSelectArray:(NSArray<PrizeListModel *> *)selectArray
{
    _selectArray = selectArray;
    CGFloat width = 70;//宽度
    CGFloat interval = 10;//间隔
    for (int i=0; i<_selectArray.count; i++) {
        PrizeListModel *model = _selectArray[i];
        UIImageView *imageView = [[UIImageView alloc]initWithFrame:CGRectMake(i*width+i*interval, 0, width, width)];
        [imageView sd_setImageWithURL:[NSURL URLWithString:model.attachment.fileUrl] placeholderImage:REPLACEIMAGE];
        [self.exchangeScrollView addSubview:imageView];
    }
    self.exchangeScrollView.contentSize = CGSizeMake(width*_selectArray.count+interval*_selectArray.count-1, 0);
}

#pragma mark -城市选择器
- (void)selectedCityClickAction
{
    [[MOFSPickerManager shareManger] showMOFSAddressPickerWithTitle:@"选择城市" cancelTitle:@"取消" commitTitle:@"完成" commitBlock:^(NSString *address, NSString *zipcode) {
        [self.addressButton setTitle:address forState:UIControlStateNormal];
    } cancelBlock:^{
        
    }];
    
}

#pragma mark - 取消
- (IBAction)cancelButtonClickAction:(UIButton *)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark - 提交
- (IBAction)submitButtonClickAction:(UIButton *)sender {
    
    if ([[self class] isBlankString:self.consigneeTextField.text]) {
        [XBLoadingView showHUDViewWithText:@"收货人不能为空"];return;
    }
    if ([[self class] isBlankString:self.mobileTextField.text]) {
        [XBLoadingView showHUDViewWithText:@"联系电话不能为空"];return;
    }
    if (![HENLENSONG isValidateMobile:self.mobileTextField.text]) {
        [XBLoadingView showHUDViewWithText:@"手机号码格式不正确"];return;
    }
    if ([[self class] isBlankString:self.addressButton.currentTitle]) {
        [XBLoadingView showHUDViewWithText:@"地址不能为空"];return;
    }
    if ([[self class] isBlankString:self.addressDetailsTextField.text]) {
        [XBLoadingView showHUDViewWithText:@"详细地址不能为空"];return;
    }
    [self savePrizeRecord];
}

#pragma mark - 保存兑奖单
- (void)savePrizeRecord
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];
    NSLog(@"%@",[[self.prizeBill toDictionary] JSONString]);
    [HTTP networkRequestWithURL:SERVERREQUESTURL(SAVEPRIZEBILL) withRequestType:ZERO withParameter:self.prizeBill withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if (RESULT(returnValue)) {
            [XBLoadingView showHUDViewWithSuccessText:@"申请成功" completeBlock:^{
                if (weakSelf.requestFinishBlock) {
                    weakSelf.requestFinishBlock();
                }
                [weakSelf dismissViewControllerAnimated:YES completion:nil];
            }];
            
        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
    } withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}



#pragma mark - lazy
- (RsPrizeBill *)prizeBill
{
    if (!_prizeBill) {
        _prizeBill = [[RsPrizeBill alloc]init];
        //收货人
        TOPrizeBillEntity *consignee = [[TOPrizeBillEntity alloc]init];
        consignee.employee = [Shoppersmanager manager].shoppers.employee.fid;
        consignee.receiver = self.consigneeTextField.text;
        consignee.mobilephone = self.mobileTextField.text;
        consignee.receiveAddress = [NSString stringWithFormat:@"%@%@",self.addressButton.currentTitle,self.addressDetailsTextField.text];
        _prizeBill.bill = consignee;
        //兑换礼品
        NSMutableArray *array = [NSMutableArray array];
        for (PrizeListModel *model in self.selectArray) {
            TOPrizeBillDetailsEntity *entity = [[TOPrizeBillDetailsEntity alloc]init];
            TOPrizeEntity *prize = [[TOPrizeEntity alloc]init];
            prize.fid = model.fid;
            entity.prize = prize;
            [array addObject:entity];
        }
        _prizeBill.details = (NSArray<TOPrizeBillDetailsEntity> *)array;
    }
    return _prizeBill;
}

@end
