//
//  PrizeExchangeInformationTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/22.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PrizeExchangeInformationTableViewCell.h"
#import "GiftInformationView.h"

@implementation PrizeExchangeInformationTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
}


- (void)setGiftDetailsArray:(NSArray<TOPrizeBillDetailsEntity> *)giftDetailsArray
{
    for (UIView *view in self.contentView.subviews) {
        [view removeFromSuperview];
    }
    _giftDetailsArray = giftDetailsArray;
    CGFloat itemHeight = 100;
    CGFloat tandemInterval = 20;
    CGFloat horizontalInterval = 300;
    for (int i=0; i<_giftDetailsArray.count; i++) {
        TOPrizeBillDetailsEntity *entity = _giftDetailsArray[i];
        GiftInformationView *giftView = [[GiftInformationView alloc] initWithializeGiftView:entity.prize.attachment.fileUrl withGiftName:entity.prize.name];
        giftView.frame = CGRectMake((i%2)*(itemHeight+horizontalInterval)+itemHeight/2, (i/2)*(itemHeight+tandemInterval)+tandemInterval, horizontalInterval, itemHeight);
        [self.contentView addSubview:giftView];
    }
}


@end
