//
//  GiftInformationView.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/29.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "GiftInformationView.h"

@implementation GiftInformationView

/**
 初始化礼品View
 
 @return GiftInformationView
 */
- (instancetype)initWithializeGiftView:(NSString *)picture withGiftName:(NSString *)name
{
    if (self = [super init]) {
        //图片
        UIImageView *giftImageView = [[UIImageView alloc]init];
        [giftImageView sd_setImageWithURL:[NSURL URLWithString:picture] placeholderImage:REPLACEIMAGE];
        [self addSubview:giftImageView];
        //文字
        UILabel *giftLabel = [[UILabel alloc]init];
        giftLabel.text = name;
        [self addSubview:giftLabel];
        [giftImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.equalTo(self);
            make.size.mas_equalTo(CGSizeMake(100, 100));
        }];
        [giftLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(giftImageView.mas_right).offset(10);
            make.top.equalTo(giftImageView).offset(10);
            make.size.mas_equalTo(CGSizeMake(100, 30));
        }];
    }
    return self;
}

@end
