//
//  LuckyDrawMainViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/28.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "LuckyDrawMainViewController.h"
#import "NotDrawTableViewCell.h"
#import "UsedDrawTableViewCell.h"
#import "CustomWKWebViewController.h"
@interface LuckyDrawMainViewController ()<UITableViewDelegate,UITableViewDataSource,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>

/**
 *  数据源
 */
@property (nonatomic,strong) NSMutableArray *datasArray;

/**
 查询抽奖
 */
@property (nonatomic,strong) RsLotteryRequest *drawModel;

@end

@implementation LuckyDrawMainViewController

#pragma mark - lazy
- (NSMutableArray *)datasArray
{
    if (!_datasArray) {
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}

- (RsLotteryRequest *)drawModel
{
    if (!_drawModel) {
        _drawModel = [[RsLotteryRequest alloc]init];
        _drawModel.winnerIdEquals = [Shoppersmanager manager].shoppers.employee.fid;
        DataPage *page = [[DataPage alloc]init];
        page.rows = KROWS;
        page.page = ONE;
        page.order = SORTDIRECTION_DESC;
        _drawModel.page = page;
    }
    return _drawModel;
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [self getDrawDatas:YES];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    self.luckyDrawMainTableView.tableFooterView = [[UIView alloc] init];
}

#pragma mark - 抽奖数据
- (void)getDrawDatas:(BOOL)isRefresh
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefaultWithView:self.view];
    [HTTP networkRequestWithURL:SERVERREQUESTURL(LOTTERYED) withRequestType:ZERO withParameter:self.drawModel withReturnValueBlock:^(id returnValue) {
        
        weakSelf.luckyDrawMainTableView.emptyDataSetSource = weakSelf;
        weakSelf.luckyDrawMainTableView.emptyDataSetDelegate = weakSelf;
        [XBLoadingView hideHUDViewWithDefaultWithView:weakSelf.view];
        if (RESULT(returnValue)) {
            if (isRefresh) {
                [weakSelf.datasArray removeAllObjects];
            }
            RsLotteryResponse *drawRecord = [[RsLotteryResponse alloc]initWithDictionary:RESPONSE(returnValue) error:nil];
            [weakSelf.datasArray addObjectsFromArray:drawRecord.list];
            [weakSelf.luckyDrawMainTableView reloadData];
        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
    } withFailureBlock:^(NSError *error) {
        [weakSelf endRefreshingForTableView:weakSelf.luckyDrawMainTableView];
        [XBLoadingView hideHUDViewWithDefaultWithView:weakSelf.view];
    }];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    RsAwardDraw *drawEntity = self.datasArray[indexPath.row];
    if ([drawEntity.draw.state isEqualToString:@"initial"]) {
        NotDrawTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"NotDrawTableViewCell" forIndexPath:indexPath];
        cell.orderNumberLabel.text = drawEntity.draw.orderNumber;
        cell.drawButton.tag = indexPath.row;
        [cell.drawButton addTarget:self action:@selector(drawButtonClickAction:) forControlEvents:UIControlEventTouchUpInside];
        return cell;
    }
    UsedDrawTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"UsedDrawTableViewCell" forIndexPath:indexPath];
    cell.orderNumber.text = drawEntity.draw.orderNumber;
    cell.drawTimeLabel.text = drawEntity.draw.drawDate;
    cell.trophyLabel.text = drawEntity.draw.awardDescription;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.datasArray.count;
}

#pragma mark - 去抽奖
- (void)drawButtonClickAction:(UIButton *)sender
{
    RsAwardDraw *drawEntity = self.datasArray[sender.tag];
    [self showLuckyDrawControl:drawEntity.draw.lotteryId andOrderNumber:drawEntity.draw.orderNumber andDrawid:drawEntity.draw.fid luckyDrawFinish:^(NSDictionary *dict) {
        
        if ([dict isKindOfClass:[NSDictionary class]]) {
            if ([BaseViewController isBlankString:dict[@"awardId"]]) {
                [XBLoadingView showHUDViewWithText:@"未中奖"];
            }else {
                [XBLoadingView showHUDViewWithText:[NSString stringWithFormat:@"恭喜你获得了 %@",dict[@"description"]]];
            }
        }
    }];
}

#pragma mark - 抽奖界面
- (void)showLuckyDrawControl:(NSString *)lotteryId andOrderNumber:(NSString *)orderNumber andDrawid:(NSString *)drawid luckyDrawFinish:(void(^)(NSDictionary *dict))complete
{
    CustomWKWebViewController *wkWebView = [[CustomWKWebViewController alloc]init];
    NSString *server = [NSString stringWithFormat:SERVERREQUESTURL(DRAW),lotteryId,drawid,orderNumber];
    NSString *newServer = [server stringByReplacingOccurrencesOfString:@"/app" withString:@""];
    wkWebView.urlString = newServer;
    [wkWebView setLuckyDrawFinishBlock:^(NSDictionary *result) {
        complete(result);
    }];
    [wkWebView setDismissLuckyDrawController:^{
        
    }];
    [self presentViewController:wkWebView animated:YES completion:nil];
}


#pragma mark -友好界面
- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无抽奖记录~" attributes:nil];
}


@end
