//
//  CardOrderInformationReusableView.m
//  
//
//  Created by 曹云霄 on 2016/10/20.
//
//

#import "CardOrderInformationReusableView.h"

@implementation CardOrderInformationReusableView


#pragma mark - 上传小票
- (IBAction)uploadReceiptsButtonClickAction:(UIButton *)sender {
    
    if ([self.delegate respondsToSelector:@selector(startUploadReceipts:)]) {
        [self.delegate startUploadReceipts:self.sectionIndex];
    }
}

- (void)setModel:(GroupByOrderNumber *)model
{
    _model = model;
    self.orderNumberLabel.text = _model.orderNumber;
    self.orderTimelabel.text = _model.orderTime;
    self.uploadReceiptsButton.hidden = [BaseViewController isBlankString:_model.orderReceiptUrl]?NO:YES;
    self.rejectNoteLabel.hidden = YES;
}


- (void)refreshHeaderView:(id<UploadReceiptsDelegate>)delegate withEntity:(RedPackageGroupbyOrderNumber *)model withSectionIndex:(NSInteger)section
{
    self.sectionIndex = section;
    self.delegate = delegate;
    self.orderNumberLabel.text = model.orderNumber;
    self.orderTimelabel.text = model.orderTime;
    self.uploadReceiptsButton.hidden = ([self.stateString isEqualToString:STUDYTASKSTATE_REFUSE] || [self.stateString isEqualToString:STUDYTASKSTATE_USED])?YES:NO;
    self.uploadReceiptsButton.hidden = ![BaseViewController isBlankString:model.orderReceiptUrl]?YES:NO;
    self.rejectNoteLabel.hidden = [self.stateString isEqualToString:STUDYTASKSTATE_REFUSE]?NO:YES;
    NSString *noteString = [model.draws.firstObject remark];
    self.rejectNoteLabel.text = [NSString stringWithFormat:@"拒绝原因：%@",noteString];

}





@end
