//
//  CardOrderInformationReusableView.h
//  
//
//  Created by 曹云霄 on 2016/10/20.
//
//

#import <UIKit/UIKit.h>

@protocol UploadReceiptsDelegate <NSObject>

/**
 上传小票
 */
- (void)startUploadReceipts:(NSInteger)sectionIndex;

@end

@interface CardOrderInformationReusableView : UICollectionReusableView

@property (nonatomic,weak) id<UploadReceiptsDelegate> delegate;

/**
 section 下标
 */
@property (nonatomic,assign) NSInteger sectionIndex;

/**
 *  上传小票
 */
@property (weak, nonatomic) IBOutlet UIButton *uploadReceiptsButton;

/**
 拒绝原因
 */
@property (weak, nonatomic) IBOutlet UILabel *rejectNoteLabel;

/**
 *  订单号
 */
@property (weak, nonatomic) IBOutlet UILabel *orderNumberLabel;

/**
 *  订单时间
 */
@property (weak, nonatomic) IBOutlet UILabel *orderTimelabel;

/**
 *  京东E卡订单数据
 */
@property (nonatomic,strong) GroupByOrderNumber *model;

/**
 状态
 */
@property (nonatomic,copy) NSString *stateString;

/**
 刷新数据
 */
- (void)refreshHeaderView:(id<UploadReceiptsDelegate>)delegate withEntity:(RedPackageGroupbyOrderNumber *)model withSectionIndex:(NSInteger)section;
@end
