//
//  Toolview.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "Toolview.h"
#import "CustomButton.h"
#import "UserViewController.h"

#define ButtonWIDTH 60 //按钮宽度
#define Buttoninterval 20//按钮间隔
#define ButtonRIGHT 54//按钮高度


@implementation Toolview


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
      
        self.backgroundColor = RGB(255, 255, 255,1);
        [self uiConfigAction];
        [self addNSNotificationCenter];
    }
    return self;
}

#pragma mark -布局
- (void)uiConfigAction
{
    //阴影
    self.layer.shadowColor = [UIColor blackColor].CGColor;
    self.layer.shadowRadius = 10;
    self.layer.shadowOpacity = 0.5;

    //图标
    UIImageView *iconImage = [[UIImageView alloc]initWithFrame:CGRectMake(50, 13, 115, 35)];
    iconImage.image = TCImage(@"欧");
    iconImage.userInteractionEnabled = YES;
    [iconImage addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(showHomeController)]];
    [self addSubview:iconImage];
    
    //输入框背景
    UIView *backView = [[UIView alloc]initWithFrame:CGRectMake(200, (NavigationHeight-35)/2, 220, 35)];
    backView.backgroundColor = RGB(242, 242, 242,1);
    backView.layer.masksToBounds = YES;;
    backView.layer.cornerRadius = kCornerRadius;
    backView.layer.borderWidth = 1;
    backView.layer.borderColor = RGB(209, 209, 209,1).CGColor;
    [self addSubview:backView];

    //搜索图标
    UIImageView *imageview = [[UIImageView alloc]initWithFrame:CGRectMake(10, 7.5, 20, 20)];
    imageview.image = TCImage(@"search");
    [backView addSubview:imageview];
    
    //输入框
    self.inputField = [[UITextField alloc]initWithFrame:CGRectMake(45, 0, 170, 35)];
    self.inputField.borderStyle = UITextBorderStyleNone;
    self.inputField.placeholder = @"请输入关键字";
    self.inputField.font = [UIFont systemFontOfSize:12];
    self.inputField.returnKeyType = UIReturnKeySearch;
    [backView addSubview:self.inputField];
    
    //扫描二维码
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(backView.frame.size.width+backView.frame.origin.x+15, (NavigationHeight-20)/2, 25, 20);
    [button setBackgroundImage:TCImage(@"圆角矩形-3") forState:UIControlStateNormal];
    [button addTarget:self action:@selector(qrCodeButtonClickAction) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:button];
    
    //按钮
    NSString *realName = [[Shoppersmanager manager].shoppers.employee.realName length]?[Shoppersmanager manager].shoppers.employee.realName:@"服务导购";
    NSArray *titleArray = [NSArray arrayWithObjects:@"功能菜单",@"消息",@"公告",realName,@"我的客户",@"购物袋", nil];
    //图片
    NSArray *imageArray = [NSArray arrayWithObjects:@"dial",@"message",@"tips",@"矢量智能对象-1",@"data",@"ablum", nil];
    for (int i=1; i<titleArray.count+1; i++) {
        
        CustomButton *button = [CustomButton buttonWithType:UIButtonTypeCustom];
        button.frame = CGRectMake(ScreenWidth-(i*ButtonWIDTH + Buttoninterval*(i-1)), 10, ButtonWIDTH, ButtonRIGHT);
        [button setTitleColor:kMainBlueColor forState:UIControlStateNormal];
        [button setTitle:[titleArray objectAtIndex_opple:i-1] forState:UIControlStateNormal];
        button.tag = 100+i-1;
        [button addTarget:self action:@selector(buttonClick:) forControlEvents:UIControlEventTouchUpInside];
        [button setImage:TCImage([imageArray objectAtIndex_opple:i-1]) forState:UIControlStateNormal];
        [self addSubview:button];
        if (i == titleArray.count) {
            SHARED_APPDELEGATE.shoppingCarPoint = [self convertPoint:CGPointMake(button.center.x, button.center.y) toView:self.window];
        }
        //未读公告
        if (i == 3) {
            button.instructionsNumber = [Shoppersmanager manager].shoppers.hasNotReadAffiche;
        }
        //未读消息
        if (i == 2) {
            button.instructionsNumber = [Shoppersmanager manager].shoppers.hasNotReadNotice;
        }
        [self.buttonArray addObject:button];
    }
    [self setBadge];
    self.underlineView.backgroundColor = kMainBlueColor;
    [self addSubview:self.underlineView];
}

#pragma mark - 监听通知
- (void)addNSNotificationCenter
{
    //刷新购物车数量
    [Notification addObserver:self selector:@selector(refreshGoodsNumber:) name:REFRESHSHOPPINGCAR object:nil];
    //更改用户名
    [Notification addObserver:self selector:@selector(changeCustomerName:) name:CHANGECUSTOMERNAME object:nil];
    //更改导购名
    [Notification addObserver:self selector:@selector(changeshoppersName:) name:CHANGEshoppersNAME object:nil];
    //提示未读公告
    [Notification addObserver:self selector:@selector(notReadAnnouncement:) name:NOTREADANNOUNCEMENT object:nil];
    //提示未读消息
    [Notification addObserver:self selector:@selector(notReadMessage:) name:MESSAGE_COUNT object:nil];
    //显示消息界面
    [Notification addObserver:self selector:@selector(showMessageController:) name:NSNOTIFICATION_MESSAGE object:nil];
    //导购名字修改
    [Notification addObserver:self selector:@selector(refreshGuideName:) name:CHANGEGUIDENAME object:nil];
}

#pragma mark -修改导购名字
- (void)refreshGuideName:(NSNotification *)object
{
    CustomButton *button = (CustomButton *)[self viewWithTag:103];
    [button setTitle:object.object forState:UIControlStateNormal];
}

#pragma mark -刷新购物车显示数量
- (void)refreshGoodsNumber:(NSNotification *)object
{
    CustomButton *button = (CustomButton *)[self viewWithTag:105];
    NSInteger number = [object.object integerValue];
    button.instructionsNumber = number;
}

#pragma mark - 未读公告
- (void)notReadAnnouncement:(NSNotification *)object
{
    CustomButton *button = (CustomButton *)[self viewWithTag:102];
    NSInteger number = [object.object integerValue];
    button.instructionsNumber -= number;
    [Shoppersmanager manager].shoppers.hasNotReadAffiche -= number;
    [self setBadge];
}

#pragma mark - 未读消息
- (void)notReadMessage:(NSNotification *)object
{
    CustomButton *button = (CustomButton *)[self viewWithTag:101];
    NSInteger number = [object.object integerValue];
    button.instructionsNumber -= number;
    [Shoppersmanager manager].shoppers.hasNotReadNotice -= number;
    [self setBadge];
}

#pragma mark -更改当前用户名
- (void)changeCustomerName:(NSNotification *)object
{
    UIButton *button = [self viewWithTag:104];
    NSString *userName = object.object;
    if ([BaseViewController isBlankString:userName]) {
        userName = @"我的客户";
    }
    [button setTitle:userName forState:UIControlStateNormal];
}

#pragma mark -更改导购名字
- (void)changeshoppersName:(NSNotification *)object
{
    UIButton *button = [self viewWithTag:103];
    NSString *userName = object.object;
    if ([BaseViewController isBlankString:userName]) {
        userName = @"导购";
    }
    [button setTitle:userName forState:UIControlStateNormal];
}

#pragma mark -显示消息界面
- (void)showMessageController:(NSNotification *)object
{
    UIButton *button = [self viewWithTag:101];
    [self buttonClick:button];
}

#pragma mark -设置系统  Badge角标值
- (void)setBadge
{
    NSInteger count = [Shoppersmanager manager].shoppers.hasNotReadNotice + [Shoppersmanager manager].shoppers.hasNotReadAffiche;
    [JPUSHService setBadge:count];
    [UIApplication sharedApplication].applicationIconBadgeNumber = count;
}

#pragma mark -二维码扫描码
- (void)qrCodeButtonClickAction
{
    if ([self.delegate respondsToSelector:@selector(qrcodeButtonClick)]) {
        [self.delegate qrcodeButtonClick];
    }
}

#pragma mark -按钮事件响应
- (void)buttonClick:(UIButton *)button
{
    [self switchLineViewOrigin:button.tag-100];
    if ([self.delegate respondsToSelector:@selector(buttonClickAction:withButton:)]) {
        [self.delegate buttonClickAction:button.tag withButton:button];
    }
}

#pragma mark -切换lingView位置
- (void)switchLineViewOrigin:(NSInteger)selectedIndex
{
    UIButton *button = self.buttonArray[selectedIndex];
    if (button.tag != 100) {
        if (!(button.tag == 105 && ![Shoppersmanager manager].currentCustomer)) {
            self.underlineView.hidden = NO;
            [UIView animateWithDuration:0.2 delay:0 options:UIViewAnimationOptionCurveEaseOut animations:^{
                CGRect frame = self.underlineView.frame;
                frame.origin.x = button.frame.origin.x+(ButtonWIDTH-50)/2;
                frame.origin.y = ButtonRIGHT+8;
                frame.size = CGSizeMake(50, 2);
                self.underlineView.frame = frame;
            } completion:nil];
        }
    }
}

#pragma mark -显示首页
- (void)showHomeController
{
    SHARED_APPDELEGATE.tabBarController.selectedIndex = 0;
}


#pragma mark -lazy
- (NSMutableArray *)buttonArray
{
    if (!_buttonArray) {
        _buttonArray = [NSMutableArray array];
    }
    return _buttonArray;
}

- (UIView *)underlineView
{
    if(!_underlineView){
        _underlineView = [[UIView alloc]init];

    }
    return _underlineView;
}

@end
