//
//  AddressViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AddressViewController.h"
#import "MOFSPickerManager.h"

@interface AddressViewController ()



@end

@implementation AddressViewController



- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark -布局
- (void)uiConfigAction
{
    self.recipientUserBackview.layer.masksToBounds = YES;
    self.recipientUserBackview.layer.cornerRadius = kCornerRadius;
    self.phoneNumberBackview.layer.masksToBounds = YES;
    self.phoneNumberBackview.layer.cornerRadius = kCornerRadius;
    self.detailsAddressBackview.layer.masksToBounds = YES;
    self.detailsAddressBackview.layer.cornerRadius = kCornerRadius;
    self.citySelected.layer.masksToBounds = YES;
    self.citySelected.layer.cornerRadius = kCornerRadius;
    self.delectAddressButton.layer.masksToBounds = YES;
    self.delectAddressButton.layer.cornerRadius = kCornerRadius;
    self.modifyButton.layer.masksToBounds = YES;
    self.modifyButton.layer.cornerRadius = kCornerRadius;
    [self.citySelected addTarget:self action:@selector(selectedCityButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    //判断是修改还是新增
    if (_isChange) {
        self.changAddressLabe.text = @"修改收货地址";
        [self.delectAddressButton setTitle:@"删除" forState:UIControlStateNormal];
        [self.modifyButton setTitle:@"保存" forState:UIControlStateNormal];
    }else
    {
        self.changAddressLabe.text = @"新增收货地址";
    }
    self.recipientPerson.text = self.model.name;
    self.PhoneNumber.text = self.model.miblephone;
    MyclientEntityModel *address = [Customermanager manager].model;
    [self.citySelected setTitle:[NSString stringWithFormat:@"%@-%@-%@",address.province,address.city,address.country] forState:UIControlStateNormal];
    self.detailsAddress.text = self.model.address;
}

#pragma mark -取消弹出的圆角
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    self.view.superview.layer.cornerRadius = 0;
}

#pragma mark -城市选择器
- (void)selectedCityButtonClick:(UIButton *)sender
{
    [[MOFSPickerManager shareManger] showMOFSAddressPickerWithTitle:@"选择城市" cancelTitle:@"取消" commitTitle:@"完成" commitBlock:^(NSString *address, NSString *zipcode) {
        [sender setTitle:address forState:UIControlStateNormal];
    } cancelBlock:^{
        
    }];
}

#pragma mark -关闭地址输入框
- (IBAction)turnoffAddressView:(UIButton *)sender {
    
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark 新增按钮点击，或者保存
- (IBAction)addAddressButtonClick:(UIButton *)sender {
    
    NSString *phoneNumber = self.PhoneNumber.text;
    if ([BaseViewController isBlankString:self.recipientPerson.text]) {
        [XBLoadingView showHUDViewWithText:@"请输入收货人姓名"];
        return;
    }
    if ([BaseViewController isBlankString:phoneNumber]) {
        [XBLoadingView showHUDViewWithText:@"手机号码不能为空"];
        return;
    }
    if (![HENLENSONG isValidateMobile:phoneNumber]) {
        
        [XBLoadingView showHUDViewWithText:@"手机号码格式不正确"];
        return;
    }
    if ([BaseViewController isBlankString:self.detailsAddress.text]) {
        [XBLoadingView showHUDViewWithText:@"请输入详细地址"];
        return;
    }
    if ([BaseViewController isBlankString:[self.citySelected currentTitle]]) {
        [XBLoadingView showHUDViewWithText:@"请选择省市区"];
        return;
    }
    if ([sender.currentTitle isEqualToString:@"新增"]) {
       
        [self addAddressInformationRequest];
    }
    else if ([sender.currentTitle isEqualToString:@"保存"])
    {
        [self changeAddressInformationRequest];
    }
}

#pragma mark -新增地址信息
- (void)addAddressInformationRequest
{
    TOShippingAddrEntity *address = [[TOShippingAddrEntity alloc]init];
    address.consumerId = [Customermanager manager].model.fid;
    address.name = self.recipientPerson.text;
    address.miblephone = self.PhoneNumber.text;
    address.address = self.detailsAddress.text;
    //省市区
    NSArray *addressArray = [[self.citySelected currentTitle] componentsSeparatedByString:@"-"];
    address.province = addressArray[0];
    address.city = addressArray[1];
    address.country = addressArray[2];
    [XBLoadingView showHUDViewWithDefault];
    WS(weakSelf);
    [HTTP networkRequestWithURL:SERVERREQUESTURL(ADDADDRESS)  withRequestType:ZERO withParameter:address withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if (RESULT(returnValue)) {
            
            AddressModel *model = [[AddressModel alloc]initWithDictionary:[address toDictionary] error:nil];
            model.fid = RESPONSE(returnValue);
            model.isSelected = NO;
            //增加地址
            if ([weakSelf.delegate respondsToSelector:@selector(addAddressCell:)]) {
                [weakSelf.delegate addAddressCell:model];
            }
        }
        else
        {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    }withFailureBlock:^(id error) {
        [XBLoadingView hideHUDViewWithDefault];
    }];
}


#pragma mark -更改地址
- (void)changeAddressInformationRequest
{
    TOShippingAddrEntity *address = [[TOShippingAddrEntity alloc]init];
    address.consumerId = [Customermanager manager].model.fid;
    address.name = self.recipientPerson.text;
    address.miblephone = self.PhoneNumber.text;
    address.address = self.detailsAddress.text;
    //省市区
    NSArray *addressArray = [[self.citySelected currentTitle] componentsSeparatedByString:@"-"];
    address.province = addressArray[0];
    address.city = addressArray[1];
    address.country = addressArray[2];
    [XBLoadingView showHUDViewWithDefault];
    address.fid = self.model.fid;
    [XBLoadingView showHUDViewWithDefault];
    WS(weakSelf);
    [HTTP networkRequestWithURL:SERVERREQUESTURL(CHANGEADDRESS)  withRequestType:ZERO withParameter:address withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if (RESULT(returnValue)) {
            
            AddressModel *model = [[AddressModel alloc]initWithDictionary:[address toDictionary] error:nil];
            model.isSelected = NO;
            //修改地址
            if ([weakSelf.delegate respondsToSelector:@selector(changeAddresscell:withcellindex:)]) {
                [weakSelf.delegate changeAddresscell:model withcellindex:weakSelf.cellindex];
            }
        }
        else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    } withFailureBlock:^(id error) {
        [XBLoadingView hideHUDViewWithDefault];
    }];
}


#pragma mark -取消新增地址，或者删除
- (IBAction)cancelButtonClick:(UIButton *)sender {
    
    if ([sender.currentTitle isEqualToString:@"取消"]) {
        
        [self dismissViewControllerAnimated:YES completion:nil];
    }
    else if ([sender.currentTitle isEqualToString:@"删除"])
    {
        [self deleteAddressButtonClick];
    }
}


#pragma mark -删除收货地址
- (void)deleteAddressButtonClick
{
    [XBLoadingView showHUDViewWithDefault];
    WS(weakSelf);
    [HTTP networkRequestWithURL:[NSString stringWithFormat:@"%@%@",SERVERREQUESTURL(REMOVEADDRESS),_model.fid]  withRequestType:ONE withParameter:nil withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if (RESULT(returnValue)) {
            [XBLoadingView showHUDViewWithSuccessText:@"删除成功" completeBlock:^{
                if ([weakSelf.delegate respondsToSelector:@selector(delecteCell:)]) {
                    [weakSelf.delegate delecteCell:_model.fid];
                }
            }];

        }else
        {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    }withFailureBlock:^(id error) {
        [XBLoadingView hideHUDViewWithDefault];
    }];
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
