//
//  PromotionalTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/18.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PromotionalTableViewCell.h"
#import "PromotionLuckyDrawModel.h"
#import "PromotionalGoodsModel.h"
#import "PromotionalDeductionModel.h"
#import "PromotionWeChatCardModel.h"

@implementation PromotionalTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setPromotionModel:(JSONModel *)promotionModel
{
    _promotionModel = promotionModel;
        //微信卡劵
    if ([promotionModel isMemberOfClass:[PromotionWeChatCardModel class]]) {
        PromotionWeChatCardModel *weChatModel = (PromotionWeChatCardModel *)promotionModel;
        self.promotionalTitleLabel.text = [NSString stringWithFormat:@"微信卡劵: %.2f",weChatModel.total];
    }else if ([promotionModel isMemberOfClass:[PromotionalDeductionModel class]]) {
        //抵扣
        PromotionalDeductionModel *deductionModel = (PromotionalDeductionModel *)promotionModel;
        self.promotionalTitleLabel.text = [NSString stringWithFormat:@"抵扣金额: %.2f元",deductionModel.total];
    }else if ([promotionModel isMemberOfClass:[PromotionLuckyDrawModel class]]) {
        //抽奖
        self.promotionalTitleLabel.text = [NSString stringWithFormat:@"转盘抽奖: %@",self.model.descriptionString];
    }else if ([promotionModel isMemberOfClass:[PromotionalGoodsModel class]]) {
        //送商品
        PromotionalGoodsModel *goodsModel = (PromotionalGoodsModel *)promotionModel;
        self.promotionalTitleLabel.text = [NSString stringWithFormat:@"赠送商品: %@",goodsModel.goods.name];
    }
    self.accessoryType = UITableViewCellAccessoryCheckmark;
}





@end
