//
//  AllpriceTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AllpriceTableViewCell.h"


@implementation AllpriceTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

#pragma mark -赋值
- (void)setGoodsAllprice:(NSArray *)goodsAllprice
{
    _goodsAllprice = goodsAllprice;
    NSUInteger allNumber = 0;
    CGFloat allPrice = 0;
    for (ShopcarModel *model in _goodsAllprice) {
        allNumber += model.goodsNum;
        allPrice += [model.costPrice floatValue] *model.goodsNum;
    }
    self.goodsAllNumber.text = [NSString stringWithFormat:@"%ld",allNumber];
    self.goodsAllPrice.text = [NSString stringWithFormat:@"￥%.2f",allPrice];
}


#pragma mark -数据源赋值
- (void)setGoodsArray:(NSArray *)goodsArray
{
    _goodsArray = goodsArray;
    NSInteger allNumber = 0;//总数量
    CGFloat allPrice = 0;//总价格
    NSDictionary *deductionPrice = nil;//抵扣金额
    NSDictionary *weChatPrice = nil;//微信卡劵
    NSDictionary *drawPrice = nil;//转盘抽奖
    for (TOOrderdetailEntity *model in _goodsArray) {
        allNumber += [model.goodsNum integerValue];
        allPrice += [model.goodsPrice floatValue]*[model.goodsNum floatValue];
    }
     //促销列表
    for (JSONModel *model in self.promotionalArray) {
            //微信卡劵
        if ([model isMemberOfClass:[PromotionWeChatCardModel class]]) {
            PromotionWeChatCardModel *newWeChatModel = (PromotionWeChatCardModel *)model;
            weChatPrice = @{@"price":[NSString stringWithFormat:@"%.2f",self.weChatModel.wxcardDenomation],@"priority":@(newWeChatModel.priority)};

        }else if ([model isMemberOfClass:[PromotionalDeductionModel class]]) {
            //抵扣
            PromotionalDeductionModel *deductionModel = (PromotionalDeductionModel *)model;
            deductionPrice = @{@"price":[NSString stringWithFormat:@"%.2f",deductionModel.total],@"priority":@(deductionModel.priority)};

        }else if ([model isMemberOfClass:[PromotionLuckyDrawModel class]]) {
            //抽奖
            PromotionLuckyDrawModel *drawModel = (PromotionLuckyDrawModel *)model;
            drawPrice = @{@"price":[NSString stringWithFormat:@"%@",self.model.number],@"priority":@(drawModel.priority)};

        }
    }
    NSString *goodsAllPriceString = [self promotionSorting:deductionPrice andWeChatPrice:weChatPrice andDrawPrice:drawPrice andAllPrice:allPrice];
    self.goodsAllNumber.text = [NSString stringWithFormat:@"%ld",allNumber];
    self.goodsAllPrice.text = goodsAllPriceString;
}

#pragma mark - 通过优先级排列促销项
- (NSString *)promotionSorting:(NSDictionary *)deductionPrice andWeChatPrice:(NSDictionary *)weChatPrice andDrawPrice:(NSDictionary *)drawPrice andAllPrice:(CGFloat)allPrice
{
    NSMutableArray *array = [NSMutableArray array];
    if (deductionPrice) {
        [array addObject:deductionPrice];
    }
    if (weChatPrice) {
        [array addObject:weChatPrice];
    }
    if (drawPrice) {
        [array addObject:drawPrice];
    }
    //按限降序排列
    NSArray *chooseArray = [array sortedArrayUsingComparator:^NSComparisonResult(NSDictionary *obj1, NSDictionary *obj2) {
        if ([obj1[@"priority"] integerValue] < [obj2[@"priority"] integerValue]) {
            return NSOrderedDescending;
        }
        if ([obj1[@"priority"] integerValue] < [obj2[@"priority"] integerValue]) {
            return NSOrderedAscending;
        }
        return NSOrderedSame;
    }];
    //计算促销后的价格
    CGFloat newPrice = allPrice;
    NSMutableString *priceString = [NSMutableString string];
    for (NSDictionary *dict in chooseArray) {
        if ([dict isEqual:deductionPrice]) {
            CGFloat deduction = [dict[@"price"] floatValue];
            newPrice = newPrice - deduction;
            [priceString appendString:[NSString stringWithFormat:@" - %.2f",deduction]];
            
        }else if ([dict isEqual:weChatPrice]){
           CGFloat weChat = [dict[@"price"] floatValue];
           newPrice = newPrice - weChat;
            [priceString appendString:[NSString stringWithFormat:@" - %.2f",weChat]];
            
        }else if ([dict isEqual:drawPrice]){
            CGFloat draw = [self.model.number floatValue]/100.0;
            newPrice = newPrice * draw;
            [priceString appendString:[NSString stringWithFormat:@" x %@",self.model.descriptionString]];
        }
    }
    //判断促销是否为空
    if (chooseArray.count) {
        if (newPrice < 0) {
            newPrice = 0;
        }
        [priceString insertString:[NSString stringWithFormat:@"￥%.2f(%.2f",newPrice,allPrice] atIndex:0];
        [priceString appendString:@")"];
    }else{
        priceString = [NSMutableString stringWithString:[NSString stringWithFormat:@"￥%.2f",allPrice]];
    }
    return priceString;
}





















@end
