//
//  StartBreakThroughViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/15.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "StartBreakThroughViewController.h"

@interface StartBreakThroughViewController ()

@end

@implementation StartBreakThroughViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark -UI
- (void)uiConfigAction
{
    if ([[self class] isBlankString:self.passResult]) {
        self.contentLabel.text = @"即将开始答题，准备好了吗?\n Let's Go!";
        [self.startButton setTitle:@"开始答题" forState:UIControlStateNormal];
    }else {
        NSString *string = [NSString stringWithFormat:@"您已参与测试了\n还有%ld次机会",self.opportunityNumber];
        NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]initWithString:string];
        NSRange range = [string rangeOfString:[NSString stringWithFormat:@"%ld",self.opportunityNumber]];
        [attributedString addAttributes:@{NSForegroundColorAttributeName:[UIColor greenColor],NSFontAttributeName:[UIFont fontWithName:@"HelveticaNeue-Bold" size:30.0]} range:range];
        self.contentLabel.attributedText = attributedString;
        [self.startButton setTitle:@"继续答题" forState:UIControlStateNormal];
    }
}

#pragma mark -开始答题、继续答题
- (IBAction)startButtonClickAction:(UIButton *)sender {
    
    if ([self.delegate respondsToSelector:@selector(startAnswerTheQuestions)]) {
        [self.delegate startAnswerTheQuestions];
    }
}

#pragma mark -关闭
- (IBAction)closeButtonClickAction:(UIButton *)sender {
    
    if ([self.delegate respondsToSelector:@selector(closeController)]) {
        [self.delegate closeController];
    }
}













@end
