//
//  PPTListItemTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PPTListItemTableViewCell.h"
#import "AssessmentViewController.h"
@implementation PPTListItemTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
    self.studyItemLabel.hidden = YES;
}

- (void)setModel:(CustomStudyEntity *)model
{
    _model = model;
    self.studyItemTitleLabel.text = _model.title;
    
    //考核状态
    if ([BaseViewController isBlankString:_model.examResult] || [_model.examResult isEqualToString:@"0"]) {
        self.examResultImageView.hidden = YES;
        
        if (model.studyComplete == nil || !model.hasStudyTopic) {
            self.btnStartAnswer.hidden = YES;
        }else{
            self.btnStartAnswer.hidden = NO;
        }
    }else {
        self.examResultImageView.hidden = NO;
        self.btnStartAnswer.hidden = YES;
    }
}
- (IBAction)actionStartAnswer:(id)sender {
    AssessmentViewController *assessmentVc = [[AssessmentViewController getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"AssessmentViewController"];
    assessmentVc.taskId = _model.fid;
//    assessmentVc.indexPath = indexPath;
//    assessmentVc.delegate = weakSelf;
    [self.viewController.navigationController pushViewController:assessmentVc animated:YES];
}
@end
