//
//  AssessmentTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/6.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AssessmentTableViewCell.h"

@implementation AssessmentTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    self.titleNumberButton.layer.borderWidth = 1.0f;
    self.titleNumberButton.layer.borderColor = [UIColor grayColor].CGColor;
}

- (void)setStudyEntity:(CustomTOStudyTopicOptionEntity *)studyEntity
{
    _studyEntity = studyEntity;
    if (_studyEntity) {
        self.answerTitleLabel.text = _studyEntity.name;
        self.answerTitleLabel.height = _studyEntity.answerHeight-30;
        [self.titleNumberButton setTitle:_studyEntity.value forState:UIControlStateNormal];
        self.titleNumberButton.selected = _studyEntity.isSelected;
        self.titleNumberButton.backgroundColor = _studyEntity.isSelected?kMainBlueColor:[UIColor whiteColor];
    }
}

- (void)setEmigratedEntity:(CustomTOPassLevelTopicOptionEntity *)emigratedEntity
{
    _emigratedEntity = emigratedEntity;
    if (_emigratedEntity) {
        self.answerTitleLabel.text = _emigratedEntity.name;
        self.answerTitleLabel.height = _emigratedEntity.answerHeight-30;
        [self.titleNumberButton setTitle:_emigratedEntity.value forState:UIControlStateNormal];
        self.titleNumberButton.selected = _emigratedEntity.isSelected;
        self.titleNumberButton.backgroundColor = _emigratedEntity.isSelected?kMainBlueColor:[UIColor whiteColor];

    }
}



@end
