//
//  AssessmentHeaderView.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/6.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AssessmentHeaderView.h"

@implementation AssessmentHeaderView

- (void)awakeFromNib {
    [super awakeFromNib];
}


- (void)setQuestionEntity:(CustomTOStudyTopicEntity *)questionEntity
{
    _questionEntity = questionEntity;
    if (_questionEntity) {
        NSString *type = [NSString stringWithFormat:@"[%@]",[BaseViewController returnTopicTypeTitle:_questionEntity.topicType]];
        NSString *string = [NSString stringWithFormat:@"%ld、%@_____   %@",_questionEntity.lineNo,_questionEntity.title,type];
        NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]initWithString:string];
        [attributedString addAttribute:NSForegroundColorAttributeName value:kMainBlueColor range:NSMakeRange(attributedString.length-[type length], [type length])];
        self.titleLabel.attributedText = attributedString;
        self.titleLabel.height = _questionEntity.titleHeight-40;
    }
}

- (void)setEmigratedEntity:(CustomTOPassLevelTopicEntity *)emigratedEntity
{
    _emigratedEntity = emigratedEntity;
    if (_emigratedEntity) {
        NSString *type = [NSString stringWithFormat:@"[%@]",[BaseViewController returnTopicTypeTitle:_emigratedEntity.topicType]];
        NSString *string = [NSString stringWithFormat:@"%ld、%@_____   %@",_emigratedEntity.lineNo,_emigratedEntity.title,type];
        self.questionLabel.text = string;
        self.questionLabel.height = _emigratedEntity.titleHeight-23;
    }
}

@end
