//
//  VideoListViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "VideoListViewController.h"
#import "VideoListItemTableViewCell.h"
#import "VideoListSectionHeaderView.h"
#import "PPTListItemTableViewCell.h"
#import "OnlineLearningDetailViewController.h"
@interface VideoListViewController ()<UITableViewDelegate,UITableViewDataSource>


@property (weak, nonatomic) IBOutlet UIView *headerView;

@end

@implementation VideoListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTableView];
    
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    if (self.type == VideoViewTypeList) {
        [self httpRequest];
    }
}

#pragma mark - 刷新选中项
- (void)selectedIndexPath:(NSIndexPath *)indexPath withIsQualified:(BOOL)boolValue
{
    //考核状态
    RsStudyTask *studyEntity = self.datasArray[indexPath.section];
    CustomStudyEntity *studyList = studyEntity.studyTasks[indexPath.row];
    studyList.examResult = [NSString stringWithFormat:@"%d",boolValue];
    [self.studyListTableView reloadRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationAutomatic];
    
    //播放状态
    UITableViewCell *cell = [self.studyListTableView cellForRowAtIndexPath:indexPath];
    if ([cell isKindOfClass:[PPTListItemTableViewCell class]]) {
        PPTListItemTableViewCell *pptCell = (PPTListItemTableViewCell *)cell;
        pptCell.pptButton.selected = YES;
    }else if ([cell isKindOfClass:[VideoListItemTableViewCell class]]) {
        VideoListItemTableViewCell *videoCell = (VideoListItemTableViewCell *)cell;
        videoCell.playButton.selected = YES;
    }
}

- (void)httpRequest {
    WS(weakSelf);
    StudyTaskCondition *studyListModel = [[StudyTaskCondition alloc]init];
    studyListModel.employeeIdEquals = [Shoppersmanager manager].shoppers.employee.fid;
    studyListModel.typeEquals = self.studyType.fid;
    DataPage *page = [[DataPage alloc] init];
    page.page = ONE;
    page.rows = 9999;
    studyListModel.page = page;
    [XBLoadingView showHUDViewWithDefault];
    [HTTP networkRequestWithURL:SERVERREQUESTURL(STUDYLIST) withRequestType:ZERO withParameter:studyListModel withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if (RESULT(returnValue)) {
            StudyTaskResponse *responeseEty = [[StudyTaskResponse alloc]initWithDictionary:RESPONSE(returnValue) error:nil];
            if (responeseEty.studyEntity.count == 0) {
                [XBLoadingView showHUDViewWithText:@"学习内容为空！"];
                return;
            }
            
            weakSelf.datasArray = [NSMutableArray arrayWithArray:responeseEty.studyEntity];
            weakSelf.studyTypeEntity = responeseEty;
        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    }withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 数据源
- (void)setDatasArray:(NSMutableArray *)datasArray
{
    _datasArray = datasArray;
    [self.studyListTableView reloadData];
}

#pragma mark - UITableView
- (void)setUpTableView
{
    self.studyListTableView.tableFooterView = [UIView new];
    self.studyListTableView.rowHeight = 50;
    self.studyListTableView.sectionHeaderHeight = 60;
    self.studyItemTitleLabel.text = self.studyItemTitle;
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    RsStudyTask *studyEntity = self.datasArray[indexPath.section];
    CustomStudyEntity *studyList = studyEntity.studyTasks[indexPath.row];
    if ([studyList.attachment.fileUrl rangeOfString:@".ppt"].location != NSNotFound) {
        PPTListItemTableViewCell *pptItemCell = [tableView dequeueReusableCellWithIdentifier:@"PPTListItemTableViewCell" forIndexPath:indexPath];
        pptItemCell.model = studyList;
        return pptItemCell;
    }else if ([studyList.attachment.fileUrl rangeOfString:@".mp4"].location != NSNotFound){
        VideoListItemTableViewCell *videoItemCell = [tableView dequeueReusableCellWithIdentifier:@"VideoListItemTableViewCell" forIndexPath:indexPath];
        videoItemCell.model = studyList;
        return videoItemCell;
    }
    return [UITableViewCell new];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    RsStudyTask *studyTask = self.datasArray[section];
    return studyTask.studyTasks.count;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.datasArray.count;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    VideoListSectionHeaderView *headerView = [tableView dequeueReusableCellWithIdentifier:@"VideoListSectionHeaderView"];
    headerView.studyItemSectionLabel.text = [self.datasArray[section] categoryName];
    return headerView;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.type == VideoViewTypeDetail) {
        //如果已经选中再次点击无效
        UITableViewCell *playCell = [tableView cellForRowAtIndexPath:indexPath];
        if ([playCell isKindOfClass:[PPTListItemTableViewCell class]]) {
            PPTListItemTableViewCell *pptCell = (PPTListItemTableViewCell *)playCell;
            if (pptCell.pptButton.selected) {
                return;
            }
        }else if ([playCell isKindOfClass:[VideoListItemTableViewCell class]]) {
            VideoListItemTableViewCell *videoCell = (VideoListItemTableViewCell *)playCell;
            if (videoCell.playButton.selected) {
                return;
            }
        }
        //取消所有选中状态
        for (UITableViewCell *cell in self.studyListTableView.visibleCells) {
            if ([cell isKindOfClass:[PPTListItemTableViewCell class]]) {
                PPTListItemTableViewCell *pptCell = (PPTListItemTableViewCell *)cell;
                pptCell.pptButton.selected = NO;
            }
            if ([cell isKindOfClass:[VideoListItemTableViewCell class]]) {
                VideoListItemTableViewCell *videoCell = (VideoListItemTableViewCell *)cell;
                videoCell.playButton.selected = NO;
            }
        }
        if ([self.delegate respondsToSelector:@selector(seleStudyItemCellIndex:)]) {
            [self.delegate seleStudyItemCellIndex:indexPath];
        }
    }else if (self.type == VideoViewTypeList){
            OnlineLearningDetailViewController *studyDetail = [[[self class] getLearningCenterStoryboardClass]instantiateViewControllerWithIdentifier:@"OnlineLearningDetailViewController"];
            studyDetail.studyResult = self.studyTypeEntity;
            studyDetail.interIndex = indexPath;
            [self.navigationController pushViewController:studyDetail animated:YES];
    }
    
}

#pragma mark - 视频播放百分比
- (void)videoPlayProportion:(NSInteger)proportion withIndexPath:(NSIndexPath *)indexPath
{
    VideoListItemTableViewCell *videoPlayCell = [self.studyListTableView cellForRowAtIndexPath:indexPath];
    RsStudyTask *studyEntity = self.datasArray[indexPath.section];
    CustomStudyEntity *studyList = studyEntity.studyTasks[indexPath.row];
    studyList.attachment.playPercent = [NSString stringWithFormat:@"%ld",proportion];
    [videoPlayCell.studyProgressView updateChartByCurrent:@(proportion)];
    NSLog(@"----%ld",proportion);
}

#pragma mark -缩小动画
- (void)narrowAnimation
{
    [UIView animateWithDuration:0.3 animations:^{
        self.view.frame = CGRectMake(ScreenWidth*2/3 + 5, NavigationHeight,ScreenWidth/3-5, ScreenHeight-64);
    }];
}



@end
