//
//  VideoListViewController.h
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"
#import "VideoHelperViewController.h"

typedef NS_ENUM(NSInteger, VideoViewType) {
    VideoViewTypeList,
    VideoViewTypeDetail
};

/**
 选中学习项
 */
@protocol SelectStudyItemDelegate <NSObject>
@required

/**
 学习项

 @param indexPath 下标
 */
- (void)seleStudyItemCellIndex:(NSIndexPath *)indexPath;

@end

@interface VideoListViewController : BaseViewController<VideoPlayProgressDelegate>

@property (nonatomic,weak) id<SelectStudyItemDelegate> delegate;

/**
 学习列表
 */
@property (weak, nonatomic) IBOutlet UITableView *studyListTableView;

/**
 学习类别
 */
@property (weak, nonatomic) IBOutlet UILabel *studyItemTitleLabel;

/**
 学习类别
 */
@property (nonatomic,copy) NSString *studyItemTitle;

/**
 学习列表数据源
 */
@property (nonatomic,strong) NSMutableArray *datasArray;

/**
 学习项
 */
@property (nonatomic,copy) StudyTaskResponse *studyTypeEntity;

/**
 页面是纯列表还是在详情旁边
 */
@property (nonatomic, assign) VideoViewType type;

@property (strong, nonatomic) TOStudyTaskEntity *studyType;


/**
 刷新选中项

 @param indexPath 下标
 @param boolValue 是否通过考核
 */
- (void)selectedIndexPath:(NSIndexPath *)indexPath withIsQualified:(BOOL)boolValue;

/**
 缩小
 */
- (void)narrowAnimation;
@end
