//
//  OnlineLearningViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/16.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "OnlineLearningViewController.h"
#import "OnlineLearningTableViewCell.h"
#import "VideoListViewController.h"
#import "OnlineLearningDetailViewController.h"

@interface OnlineLearningViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>


/**
 学习类别
 */
@property (nonatomic,strong) NSMutableArray *studyTypeArray;

@end

@implementation OnlineLearningViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpCollectionView];
    [self getLearningModuleData];
}

#pragma mark - UICollectionView
- (void)setUpCollectionView
{
    self.onlineLearningFlowLayout.itemSize = CGSizeMake((ScreenWidth-60)/3.0, ((ScreenWidth-60)/3.0)*0.9);
    self.onlineLearningFlowLayout.sectionInset = UIEdgeInsetsMake(20, 20, 20, 20);
    self.onlineLearningFlowLayout.minimumLineSpacing = 10;
    self.onlineLearningFlowLayout.minimumInteritemSpacing = 10;
}

#pragma mark - 学习模块数据
- (void)getLearningModuleData
{
  WS(weakSelf);
  [XBLoadingView showHUDViewWithDefault];;
  [HTTP networkWithDictionaryRequestWithURL:SERVERREQUESTURL(STUDYTYPES) withRequestType:ONE withParameter:nil withReturnValueBlock:^(id returnValue) {
      
      [XBLoadingView hideHUDViewWithDefault];
      if (RESULT(returnValue)) {
          StudyTypeResponse *response = [[StudyTypeResponse alloc]initWithDictionary:RESPONSE(returnValue) error:nil];
          [weakSelf.studyTypeArray addObjectsFromArray:response.types];
      }else {
          [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
      }
      [weakSelf.onlineLearningCollectionView reloadData];
      
  }withFailureBlock:^(NSError *error) {
      [XBLoadingView hideHUDViewWithDefault];
      [XBLoadingView showHUDViewWithText:error.localizedDescription];
  }];
}

#pragma mark - <UICollectionViewDelegate,UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.studyTypeArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    OnlineLearningTableViewCell *learningCell = [collectionView dequeueReusableCellWithReuseIdentifier:@"OnlineLearningTableViewCell" forIndexPath:indexPath];
    learningCell.studeType = self.studyTypeArray[indexPath.row];
    return learningCell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    TOStudyTaskEntity *studyType = self.studyTypeArray[indexPath.row];;

    VideoListViewController *listView = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"VideoListViewController"];
    listView.studyType = studyType;
    [self.navigationController pushViewController:listView animated:YES];
    
//    WS(weakSelf);
//    StudyTaskCondition *studyListModel = [[StudyTaskCondition alloc]init];
//    studyListModel.employeeIdEquals = [Shoppersmanager manager].shoppers.employee.fid;
//    studyListModel.typeEquals = studyType.fid;
//    DataPage *page = [[DataPage alloc] init];
//    page.page = ONE;
//    page.rows = 9999;
//    studyListModel.page = page;
//    [XBLoadingView showHUDViewWithDefault];
//    [HTTP networkRequestWithURL:SERVERREQUESTURL(STUDYLIST) withRequestType:ZERO withParameter:studyListModel withReturnValueBlock:^(id returnValue) {
//        
//        [XBLoadingView hideHUDViewWithDefault];
//        if (RESULT(returnValue)) {
//            StudyTaskResponse *responeseEty = [[StudyTaskResponse alloc]initWithDictionary:RESPONSE(returnValue) error:nil];
//            if (responeseEty.studyEntity.count == 0) {
//                [XBLoadingView showHUDViewWithText:@"学习内容为空！"];
//                return;
//            }
//            
//            VideoListViewController *listView = [[[weakSelf class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"VideoListViewController"];
//            [listView view];
//            
//            listView.datasArray = [NSMutableArray arrayWithArray:responeseEty.studyEntity];
//            listView.studyTypeEntity = responeseEty;
//            [weakSelf.navigationController pushViewController:listView animated:YES];
//        }else {
//            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
//        }
//        
//    }withFailureBlock:^(NSError *error) {
//        [XBLoadingView showHUDViewWithText:error.localizedDescription];
//    }];
}


#pragma mark - lazy
- (NSMutableArray *)studyTypeArray
{
    if (!_studyTypeArray) {
        _studyTypeArray = [NSMutableArray array];
    }
    return _studyTypeArray;
}

@end
