//
//  LearningCompleteViewController.h
//  Lighting
//
//  Created by 曹云霄 on 2016/11/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"


/**
 考核
 */
@protocol BeginAssessmentDelegate <NSObject>

/**
 考核

 @param studyEntity 数据源
 @param indexPath   学习项下标
 */
- (void)beginAssessment:(CustomStudyEntity *)studyEntity withIndexPath:(NSIndexPath *)indexPath;

@end


@interface LearningCompleteViewController : BaseViewController

@property (nonatomic,weak) id<BeginAssessmentDelegate>delegate;

/**
 开始考核
 */
@property (weak, nonatomic) IBOutlet UIButton *beginAssessmentButton;

/**
 考核按钮
 */
@property (nonatomic,assign) BOOL isHidden;


/**
 获得积分
 */
@property (weak, nonatomic) IBOutlet UILabel *obtainIntegralLabel;

/**
 数据源
 */
@property (nonatomic,strong) CustomStudyEntity *studyEntity;

/**
 积分
 */
@property (nonatomic,assign) NSString *integralString;

/**
 学习项下标
 */
@property (nonatomic,strong) NSIndexPath *indexPath;


@end
