//
//  AssessmentViewController.h
//  Lighting
//
//  Created by 曹云霄 on 2016/12/6.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"



/**
 考核状态
 */
@protocol InspectionStateDelegate <NSObject>

@optional

/**
 再学一遍

 @param indexPath 学习项indexPath
 */
- (void)learningAgainButtonClick:(NSIndexPath *)indexPath;

/**
 考核通过

 @param indexPath 学习项indexPath
 */
-(void)inspectionThroughAction:(NSIndexPath *)indexPath;



@end

@interface AssessmentViewController : BaseViewController
@property (nonatomic,weak) id<InspectionStateDelegate>delegate;

/**
 考核tableview
 */
@property (weak, nonatomic) IBOutlet UITableView *assessmentTableView;

/**
 考核标题
 */
@property (weak, nonatomic) IBOutlet UILabel *assessmentTitleLabel;

/**
 考核时间
 */
@property (weak, nonatomic) IBOutlet CountDownLabel *assessmentTimeLabel;

/**
 学习任务ID
 */
@property (nonatomic,copy) NSString *taskId;

/**
 学习项下标
 */
@property (nonatomic,strong) NSIndexPath *indexPath;

@end
