//
//  LearningCenterMainViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/16.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "LearningCenterMainViewController.h"
#import "OnlineLearningViewController.h"
#import "ForumViewController.h"
#import "BreakThroughViewController.h"
#import "PerfectInformationViewController.h"
#import "DiscussMainViewController.h"
#import "ForumTypeViewController.h"

@interface LearningCenterMainViewController ()


@end

@implementation LearningCenterMainViewController

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

#pragma mark -渲染完成
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = NO;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    }
    [self queryIntegralDetails];
}

#pragma mark -视图即将消失
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    // 开启
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = YES;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = YES;
    }
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpGuideRealName];
    [self addGestureRecognizer];
    [self addNotification];
    [self improveCustomerInformation];
}

#pragma mark -UI
- (void)setUpGuideRealName
{
    self.guideNameLabel.text = [NSString stringWithFormat:@"用户名: %@",[Shoppersmanager manager].shoppers.employee.realName];
}

#pragma mark -是否需要完善客户信息
- (void)improveCustomerInformation
{
    //是否需要完善客户信息
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        if (![Shoppersmanager manager].shoppers.employee.isComplete) {
            [self perfectGuideInformation];
        }
    });
}

#pragma mark -监听导购名字修改
- (void)addNotification
{
    [Notification addObserver:self selector:@selector(refreshGuideName:) name:CHANGEGUIDENAME object:nil];
}

#pragma mark -修改导购名字
- (void)refreshGuideName:(NSNotification *)object
{
    [self setUpGuideRealName];
}

#pragma mark - 添加点击
- (void)addGestureRecognizer
{
    [self.comprehensiveDiscussionView addGestureRecognizer:[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(comprehensiveDiscussionViewClickAction:)]];
    [self.onlineLearningView addGestureRecognizer:[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(onlineLearningViewClickAction:)]];
    [self.breakthroughView addGestureRecognizer:[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(breakthroughViewClickAction:)]];
}

#pragma mark - 查询积分明细
- (void)queryIntegralDetails
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    NSString *url = [NSString stringWithFormat:SERVERREQUESTURL(INTEGRALQUERY),[Shoppersmanager manager].shoppers.employee.fid];
    [HTTP networkWithDictionaryRequestWithURL:url withRequestType:ONE withParameter:nil withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if (RESULT(returnValue)) {
            RsScoreDetails *integralDatas = [[RsScoreDetails alloc]initWithDictionary:RESPONSE(returnValue) error:nil];
            [weakSelf setUpIntegral:integralDatas];

        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    }withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 积分信息
- (void)setUpIntegral:(RsScoreDetails *)entity
{
    if (entity.currentScore == 0) {
        entity.quarterlyRanking = 0;
        entity.annualRanking = 0;
    }
    self.currentScoreLabel.text = [NSString stringWithFormat:@"%.0lf",entity.currentScore];
    self.yearRankingLabel.text = [NSString stringWithFormat:@"%ld",(long)entity.annualRanking];
    [self.guideHeadImageView sd_setImageWithURL:[NSURL URLWithString:[Shoppersmanager manager].shoppers.employee.picture] placeholderImage:GuideReplaceImage];
    [self.guideHeadImageView addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(guideHeaderViewClick:)]];
    self.quarterRankingLabel.text = [NSString stringWithFormat:@"%ld",(long)entity.quarterlyRanking];
}

#pragma mark -导购头像点击事件
- (void)guideHeaderViewClick:(UITapGestureRecognizer *)tap
{
    [self perfectGuideInformation];
}

#pragma mark - 综合讨论
- (void)comprehensiveDiscussionViewClickAction:(UITapGestureRecognizer *)sender
{
    DiscussMainViewController *forum = [[[self class] getLearningCenterStoryboardClass]instantiateViewControllerWithIdentifier:@"DiscussMainViewController"];
    [self.navigationController pushViewController:forum animated:YES];
}

#pragma mark - 在线学习
- (void)onlineLearningViewClickAction:(UITapGestureRecognizer *)sender
{
    OnlineLearningViewController *onlineLearning = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"OnlineLearningViewController"];
    [self.navigationController pushViewController:onlineLearning animated:YES];
}

#pragma mark - 闯关
- (void)breakthroughViewClickAction:(UITapGestureRecognizer *)sender
{
    BreakThroughViewController *emigrated = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"BreakThroughViewController"];
    [self.navigationController pushViewController:emigrated animated:YES];
}


@end
