//
//  TriangleIndicatorView.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/15.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "TriangleIndicatorView.h"

@implementation TriangleIndicatorView


- (instancetype)initializeView:(CGRect)frame contentLabel:(NSString *)year;
{
    if (self == [super initWithFrame:frame]) {
        
        UIImageView *imageView = [[UIImageView alloc] init];
        imageView.image = TCImage(@"triangle");
        [self addSubview:imageView];
        [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.equalTo(self);
        }];
        UILabel *label = [[UILabel alloc] init];
        label.text = year;
        label.textColor = [UIColor whiteColor];
        label.font = [UIFont systemFontOfSize:6];
        label.textAlignment = NSTextAlignmentCenter;
        [label sizeToFit];
        [self addSubview:label];
        [label mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.equalTo(self.mas_bottom);
            make.left.right.equalTo(self);
            make.height.mas_equalTo(self.height*0.5);
        }];
    }
    return self;
}


- (void)setYearString:(NSString *)yearString
{
    for (id object in self.subviews) {
        if ([object isKindOfClass:[UILabel class]]) {
            UILabel *label = (UILabel *)object;
            label.text = yearString;break;
        }
    }
}


@end
