//
//  KeyBoardAccessoryView.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/9.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "KeyBoardAccessoryView.h"

@implementation KeyBoardAccessoryView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        self.backgroundColor = [UIColor whiteColor];
        [self uiConfigAction];
    }
    return self;
}

#pragma mark - UI
- (void)uiConfigAction
{
    NSArray *itemArray = @[@"camera",@"album",@"smilingface"];
    CGFloat size = 25;
    CGFloat interval = 30;
    for (int i=0; i<itemArray.count; i++) {
        UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
//        button.imageView
        button.tag = i;
        button.tintColor = [UIColor whiteColor];
        [button setBackgroundImage:TCImage(itemArray[i]) forState:UIControlStateNormal];
        button.frame = CGRectMake(i*size+i*interval+50, (self.height-size)/2, size, size);
        [button addTarget:self action:@selector(extensionButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        if (i == itemArray.count-1) {
            [button setBackgroundImage:TCImage(@"keyboard") forState:UIControlStateSelected];
        }
        [self addSubview:button];
    }
}

#pragma mark - Click
- (void)extensionButtonClick:(UIButton *)sender
{
    if ([self.delegate respondsToSelector:@selector(extensionButtonClick:)]) {
        [self.delegate extensionButtonClick:sender];
    }
}

@end
