//
//  ForumDetailBottomView.m
//  Lighting
//
//  Created by Javen on 2017/4/17.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "ForumDetailBottomView.h"
#import "ForumDetailBottomPictureCell.h"
@implementation ForumDetailBottomView

- (void)awakeFromNib {
    [super awakeFromNib];
    self.collectionView.delegate = self;
    self.collectionView.dataSource = self;

    self.layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    self.layout.itemSize = CGSizeMake(64, 64);
    self.layout.sectionInset = UIEdgeInsetsMake(0, 30, 0, 30);

    self.toolView = [[ZJKeyBoardAccessoryView alloc] initWithFrame:CGRectMake(0, 0, ScreenWidth, 44)];
    
    self.layoutHeight.constant = 50;
    //结束选择照片 (删除照片时这里也会回调）
    WS(weakSelf);
    self.toolView.blockFinishSelected = ^{
        [weakSelf.collectionView reloadData];
        if (weakSelf.toolView.arrSelectedPhotos.count > 0) {
            weakSelf.layoutHeight.constant = 114;
        }else{
            weakSelf.layoutHeight.constant = 50;
        }
        
    };
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.toolView.arrSelectedPhotos.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    ForumDetailBottomPictureCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"ForumDetailBottomPictureCell" forIndexPath:indexPath];
    UIImage *image = self.toolView.arrSelectedPhotos[indexPath.row];
    cell.imageView.image = image;
    WS(weakSelf);
    cell.blockDelete = ^{
        ShowAlertView(@"提示", @"确认删除", @[@"确认",@"取消"], UIAlertControllerStyleAlert, ^(NSInteger index) {
            if (index == ONE) {
                return;
            }
            [weakSelf.toolView deletePhotoWithIndex:indexPath.row];
        });
    };
    return cell;
}

- (void)clearPhoto {
    [self.toolView deleteAll];
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
