//
//  PostPhotoManagerViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/14.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PostPhotoManagerViewController.h"
#import "MWPhotoBrowser.h"
#import "PhotoManagerCollectionViewCell.h"
@interface PostPhotoManagerViewController ()<MWPhotoBrowserDelegate>

@property (nonatomic,strong) NSMutableArray *browserArray;

@end

@implementation PostPhotoManagerViewController

#pragma mark - lazy
- (NSMutableArray *)browserArray
{
    if (!_browserArray) {
        _browserArray = [NSMutableArray array];
    }
    return _browserArray;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpCollectionView];
}

- (void)setImageArray:(NSMutableArray *)imageArray
{
    _imageArray = imageArray;
    [self.photoManagerCollectionView reloadData];
}

#pragma mark - UICollectionView
- (void)setUpCollectionView
{
    //2表示2个间隔20的距离,40 表示左右边距
    CGFloat width = (ScreenWidth-20-27*2)/3.0;
    self.photoManagerFlowLayout.itemSize = CGSizeMake(width, width);
    self.photoManagerFlowLayout.minimumLineSpacing = 10;
    self.photoManagerFlowLayout.minimumInteritemSpacing = 10;
    self.photoManagerFlowLayout.sectionInset = UIEdgeInsetsMake(0, 27, 0, 27);
}

#pragma mark - <UICollectionViewDelegate,UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.imageArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    PhotoManagerCollectionViewCell *photoCell = [collectionView dequeueReusableCellWithReuseIdentifier:@"PhotoManagerCollectionViewCell" forIndexPath:indexPath];
    [photoCell.photoImageView sd_setImageWithURL:[NSURL URLWithString:self.imageArray[indexPath.item]] placeholderImage:REPLACEIMAGE];
    photoCell.photoImageView.tag = indexPath.item;
    return photoCell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    [self.browserArray removeAllObjects];
    for (NSString *string in self.imageArray) {
        MWPhoto *photo = [MWPhoto photoWithURL:[NSURL URLWithString:string]];
        [self.browserArray addObject:photo];
    }
    MWPhotoBrowser *browser = [[MWPhotoBrowser alloc] initWithDelegate:self];
    [browser setCurrentPhotoIndex:indexPath.item];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:browser];
    [self.navigationController presentViewController:nav animated:YES completion:nil];
}

#pragma mark - <MWPhotoBrowserDelegate>
- (NSUInteger)numberOfPhotosInPhotoBrowser:(MWPhotoBrowser *)photoBrowser
{
    return self.browserArray.count;
}

- (id<MWPhoto>)photoBrowser:(MWPhotoBrowser *)photoBrowser photoAtIndex:(NSUInteger)index
{
    if (index < self.browserArray.count) {
        return [self.browserArray objectAtIndex:index];
    }
    return nil;
}

- (NSString *)photoBrowser:(MWPhotoBrowser *)photoBrowser titleForPhotoAtIndex:(NSUInteger)index
{
    return [NSString stringWithFormat:@"%ld/%ld", index + 1, self.browserArray.count];
}

@end
