//
//  PhotoManagerViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/9.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PhotoManagerViewController.h"
#import "PhotoManagerCollectionViewCell.h"
#import "MWPhotoBrowser.h"

@interface PhotoManagerViewController ()<UICollectionViewDelegate,UICollectionViewDataSource,MWPhotoBrowserDelegate>

@property (nonatomic,strong) NSMutableArray *browserArray;

@end

@implementation PhotoManagerViewController

#pragma mark - lazy
- (NSMutableArray *)browserArray
{
    if (!_browserArray) {
        _browserArray = [NSMutableArray array];
    }
    return _browserArray;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpCollectionView];
}

- (void)setImageArray:(NSMutableArray *)imageArray
{
    _imageArray = imageArray;
    [self.photoManagerCollectionView reloadData];
}

#pragma mark - UICollectionView
- (void)setUpCollectionView
{
    //7表示7个间隔20的距离,40 表示左右边距
    self.photoManagerFlowLayout.itemSize = CGSizeMake((ScreenWidth-40-7*20)/8, (ScreenWidth-40-7*20)/8);
    self.photoManagerFlowLayout.minimumLineSpacing = 20;
    self.photoManagerFlowLayout.minimumInteritemSpacing = 20;
}

#pragma mark - <UICollectionViewDelegate,UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.imageArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    PhotoManagerCollectionViewCell *photoCell = [collectionView dequeueReusableCellWithReuseIdentifier:@"PhotoManagerCollectionViewCell" forIndexPath:indexPath];
    id object = self.imageArray[indexPath.item];
    if ([object isKindOfClass:[UIImage class]]) {
       photoCell.photoImageView.image = self.imageArray[indexPath.item];
    }else if ([object isKindOfClass:[NSString class]]) {
        [photoCell.photoImageView sd_setImageWithURL:[NSURL URLWithString:object] placeholderImage:REPLACEIMAGE];
    }
    photoCell.photoImageView.tag = indexPath.item;
    [photoCell.photoImageView addGestureRecognizer:[[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPressClickAction:)]];
    return photoCell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    [self.browserArray removeAllObjects];
    id object = [self.imageArray firstObject];
    if ([object isKindOfClass:[UIImage class]]) {
        for (UIImage *image in self.imageArray) {
            MWPhoto *photo = [MWPhoto photoWithImage:image];
            [self.browserArray addObject:photo];
        }
    }else if ([object isKindOfClass:[NSString class]]) {
        for (NSString *string in self.imageArray) {
            MWPhoto *photo = [MWPhoto photoWithURL:[NSURL URLWithString:string]];
            [self.browserArray addObject:photo];
        }
    }
    MWPhotoBrowser *browser = [[MWPhotoBrowser alloc] initWithDelegate:self];
    [browser setCurrentPhotoIndex:indexPath.item];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:browser];
    [self.navigationController presentViewController:nav animated:YES completion:nil];
}

#pragma mark - <MWPhotoBrowserDelegate>
- (NSUInteger)numberOfPhotosInPhotoBrowser:(MWPhotoBrowser *)photoBrowser
{
    return self.browserArray.count;
}

- (id<MWPhoto>)photoBrowser:(MWPhotoBrowser *)photoBrowser photoAtIndex:(NSUInteger)index
{
    if (index < self.browserArray.count) {
        return [self.browserArray objectAtIndex:index];
    }
    return nil;
}

- (NSString *)photoBrowser:(MWPhotoBrowser *)photoBrowser titleForPhotoAtIndex:(NSUInteger)index
{
    return [NSString stringWithFormat:@"%ld/%ld", index + 1, self.browserArray.count];
}

#pragma mark -长按删除
- (void)longPressClickAction:(UILongPressGestureRecognizer *)sender
{
    WS(weakSelf);
    ShowAlertView(@"提示", @"是否删除此项？", @[@"确认",@"取消"], UIAlertControllerStyleAlert, ^(NSInteger index) {
        if (index == ONE) {
            return;
        }
        [weakSelf.imageArray removeObjectAtIndex:sender.view.tag];
        [weakSelf.photoManagerCollectionView reloadData];
    });
}

@end
