//
//  ForumViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/24.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ForumViewController.h"
#import "ForumTableViewCell.h"
#import "ForumItemListViewController.h"


@interface ForumViewController ()<UITableViewDelegate,UITableViewDataSource,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>

@property (nonatomic,strong) ForumCategoryResponse *category;


@end

@implementation ForumViewController

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self getForumAllTypeAction];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpForumTableView];
    [self setUpRefreshAction];
}

#pragma mark - UITableView
- (void)setUpForumTableView
{
    self.forumTableView.tableFooterView = [UIView new];
    self.forumTableView.rowHeight = 90;
    [Notification addObserver:self selector:@selector(refreshForumList:) name:REFRESH_FROUMLIST object:nil];
}

#pragma mark -选中时间轴刷新列表
- (void)refreshForumList:(NSNotification *)object
{
    self.typeId = object.object;
    [self.forumTableView.mj_header beginRefreshing];
}

#pragma mark - 设置刷新
- (void)setUpRefreshAction
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        [weakSelf getForumAllTypeAction];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.forumTableView.mj_header =headerRefresh;
}

#pragma mark - 获取论坛项Type
- (void)getForumAllTypeAction
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    [HTTP networkWithDictionaryRequestWithURL:[NSString stringWithFormat:SERVERREQUESTURL(FORUMCATEGORYS),self.typeId,[Shoppersmanager manager].shoppers.employee.fid] withRequestType:ONE withParameter:nil withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        [weakSelf endRefreshingForTableView:weakSelf.forumTableView];
        weakSelf.forumTableView.emptyDataSetDelegate = weakSelf;
        weakSelf.forumTableView.emptyDataSetSource = weakSelf;
        if (RESULT(returnValue)) {
            weakSelf.category = [[ForumCategoryResponse alloc] initWithDictionary:RESPONSE(returnValue) error:nil];
            [weakSelf.forumTableView reloadData];
        }else{
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
    } withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ForumTableViewCell *forumCell = [tableView dequeueReusableCellWithIdentifier:@"ForumTableViewCell" forIndexPath:indexPath];
    forumCell.categoryEntity = self.category.categories[indexPath.row];
    return forumCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.category.categories.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ForumItemListViewController  *itemListVc = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"ForumItemListViewController"];
    TOForumCategoryEntity *category = self.category.categories[indexPath.row];
    category.typeId = self.typeId;
    itemListVc.category = category;
    itemListVc.isPosting = [category.name isEqualToString:@"欧普问问"]?0:1;
    [self.navigationController pushViewController:itemListVc animated:YES];
}


#pragma mark -释放
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

- (CGFloat)verticalOffsetForEmptyDataSet:(UIScrollView *)scrollView {
    return  64.0;
}


@end
