//
//  ForumTypeViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/7.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "ForumTypeViewController.h"
#import "ForumTypeTableViewCell.h"
#import "ForumViewController.h"

@interface ForumTypeViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic,strong) ForumTypeResponse *typeResult;

@end

@implementation ForumTypeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpForumTableView];
    [self setUpRefreshAction];
}

#pragma mark - UITableView
- (void)setUpForumTableView
{
    self.forumTypeTableView.tableFooterView = [UIView new];
    self.forumTypeTableView.rowHeight = 90;
}

#pragma mark - 设置刷新
- (void)setUpRefreshAction
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        [weakSelf getForumAllTypeAction];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.forumTypeTableView.mj_header =headerRefresh;
    [self.forumTypeTableView.mj_header beginRefreshing];
}

#pragma mark - 获取论坛项Type
- (void)getForumAllTypeAction
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    [HTTP networkWithDictionaryRequestWithURL:SERVERREQUESTURL(FORUMTYPS) withRequestType:ONE withParameter:nil withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        [weakSelf endRefreshingForTableView:weakSelf.forumTypeTableView];
        if (RESULT(returnValue)) {
            weakSelf.typeResult = [[ForumTypeResponse alloc] initWithDictionary:RESPONSE(returnValue) error:nil];
            [weakSelf.forumTypeTableView reloadData];
        }else{
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
    } withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ForumTypeTableViewCell *forumCell = [tableView dequeueReusableCellWithIdentifier:@"ForumTypeTableViewCell" forIndexPath:indexPath];
    forumCell.entity = self.typeResult.list[indexPath.row];
    return forumCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.typeResult.list.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ForumViewController *itemCategoryVc = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"ForumViewController"];
    itemCategoryVc.typeId = [self.typeResult.list[indexPath.row] fid];
    [self.navigationController pushViewController:itemCategoryVc animated:YES];
}


@end
