//
//  DiscussModuleViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/15.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "DiscussModuleViewController.h"
#import "DiscussModuleCollectionViewCell.h"
#import "ForumItemListViewController.h"

@interface DiscussModuleViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>

@property (nonatomic,strong) ForumTypeResponse *result;
@end

@implementation DiscussModuleViewController

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self getClassificationList];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [self uiConfigAction];
}

#pragma mark - 获取分类帖子列表
- (void)getClassificationList
{
    [XBLoadingView showHUDViewWithDefaultWithView:self.view];
    WS(weakSelf);
    [HTTP networkWithDictionaryRequestWithURL:[NSString stringWithFormat:SERVERREQUESTURL(DEFAULTFORUM_CATEGORY),[Shoppersmanager manager].shoppers.employee.fid] withRequestType:GET withParameter:nil withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefaultWithView:self.view];
        if (RESULT(returnValue)) {
            weakSelf.result = [[ForumTypeResponse alloc] initWithDictionary:RESPONSE(returnValue) error:nil];
            [weakSelf.moduleCollectionView reloadData];
        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        [weakSelf.moduleCollectionView reloadData];
    } withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.moduleFlowLayout.itemSize = CGSizeMake((ScreenWidth-60)/3.0, (ScreenWidth-60)/3.0*0.4);
    self.moduleFlowLayout.minimumInteritemSpacing = 10;
    self.moduleFlowLayout.minimumLineSpacing = 10;
}


#pragma mark -<UICollectionViewDelegate,UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.result.list.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    DiscussModuleCollectionViewCell *moduleCell = [collectionView dequeueReusableCellWithReuseIdentifier:@"DiscussModuleCollectionViewCell" forIndexPath:indexPath];
    TOForumCategoryEntity *entity = self.result.list[indexPath.item];
    [moduleCell refreshCell:entity];
    return moduleCell;
}


- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    ForumItemListViewController *itemListVc = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"ForumItemListViewController"];
    TOForumCategoryEntity *category = self.result.list[indexPath.row];
    category.typeId = self.result.forumType.fid;
    itemListVc.category = category;
    
    itemListVc.isPosting = [category.name isEqualToString:@"欧普问问"]?2:1;
    [self.navigationController pushViewController:itemListVc animated:YES];
}




@end
