//
//  DiscussMainViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/15.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "DiscussMainViewController.h"
#import "DiscussModuleViewController.h"
#import "DateCalibrationViewController.h"
#import "ForumViewController.h"

@interface DiscussMainViewController ()

@property (nonatomic,strong) DiscussModuleViewController *moduleVc;
@property (nonatomic,strong) DateCalibrationViewController *dateCalibrationVc;
@property (nonatomic,strong) ForumViewController *forumListVc;

@end

@implementation DiscussMainViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addChildViewControllers];
}

#pragma mark -添加自控制器
- (void)addChildViewControllers
{
    [self addChildViewController:self.moduleVc];
    [self.view addSubview:self.moduleVc.view];
    [self addChildViewController:self.dateCalibrationVc];
    [self.view addSubview:self.dateCalibrationVc.view];
    [self addChildViewController:self.forumListVc];
    [self.view addSubview:self.forumListVc.view];
}

#pragma mark -布局加载完成
- (void)viewDidLayoutSubviews
{
    [self.moduleVc.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.view.mas_left).mas_offset(20);
        make.right.equalTo(self.view.mas_right).mas_offset(-20);
        make.top.equalTo(self.contentLabel.mas_bottom).mas_offset(10);
        make.height.mas_equalTo(300);
    }];
    [self.dateCalibrationVc.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.view.mas_left).mas_offset(20);
        make.right.equalTo(self.view.mas_right).mas_offset(-20);
        make.top.equalTo(self.moduleVc.view.mas_bottom).mas_offset(10);
        make.height.mas_equalTo(60);
    }];
    [self.forumListVc.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.view.mas_left).mas_offset(20);
        make.right.equalTo(self.view.mas_right).mas_offset(-20);
        make.top.equalTo(self.dateCalibrationVc.view.mas_bottom);
        make.bottom.equalTo(self.view.mas_bottom);
    }];
}

#pragma mark -lazy
- (UIViewController *)moduleVc
{
    if (!_moduleVc) {
        _moduleVc = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"DiscussModuleViewController"];
    }
    return _moduleVc;
}

- (UIViewController *)dateCalibrationVc
{
    if (!_dateCalibrationVc) {
        _dateCalibrationVc = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"DateCalibrationViewController"];
    }
    return _dateCalibrationVc;
}

- (UIViewController *)forumListVc
{
    if (!_forumListVc) {
        _forumListVc = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"ForumViewController"];
    }
    return _forumListVc;
}






@end
