//
//  DateCalibrationDetailViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/15.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "DateCalibrationDetailViewController.h"
#import "CalibrationDetailCollectionCell.h"
@interface DateCalibrationDetailViewController ()<UICollectionViewDataSource,UICollectionViewDelegate>


@end

@implementation DateCalibrationDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

- (void)setTimeLineEntity:(TimeLineType *)timeLineEntity
{
    _timeLineEntity = timeLineEntity;
    [self.calibrationDetailCollectionView reloadData];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.calibrationDetailFlowLayout.itemSize = CGSizeMake((ScreenWidth-40)/12.0, 60);
    self.calibrationDetailFlowLayout.minimumInteritemSpacing = 0;
    self.calibrationDetailFlowLayout.minimumLineSpacing = 0;
}

#pragma mark -<UICollectionViewDelegate,UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.timeLineEntity.list.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    CalibrationDetailCollectionCell *calibrationDetailCell = [collectionView dequeueReusableCellWithReuseIdentifier:@"CalibrationDetailCollectionCell" forIndexPath:indexPath];
    calibrationDetailCell.indexPath = indexPath;
    [calibrationDetailCell refreshCell:self.timeLineEntity.list[indexPath.item]];
    return calibrationDetailCell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    CalibrationDetailCollectionCell *cell = (CalibrationDetailCollectionCell *)[collectionView cellForItemAtIndexPath:indexPath];
    [Notification postNotificationName:ANIMATION object:cell];
}

- (void)collectionView:(UICollectionView *)collectionView didDeselectItemAtIndexPath:(NSIndexPath *)indexPath
{
    CalibrationDetailCollectionCell *cell = (CalibrationDetailCollectionCell *)[collectionView cellForItemAtIndexPath:indexPath];
    [cell timeLineDefauld];
}











@end
