//
//  ContentTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/9.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ContentTableViewCell.h"
#import "STEmojiKeyboard.h"

@implementation ContentTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];

    [self setUpToolView];
}

#pragma mark - ToolView
- (void)setUpToolView {
    KeyBoardAccessoryView *toolView = [[KeyBoardAccessoryView alloc] initWithFrame:CGRectMake(0, 0, ScreenWidth, 44)];
    toolView.delegate = self;
    self.contentTextView.inputAccessoryView = toolView;
    self.contentTextView.m_placeHolder = @"请输入内容";
}

#pragma mark - Click
- (void)extensionButtonClick:(UIButton *)sender {
    switch (sender.tag) {
        case Camera: {
            if ([self.delgate respondsToSelector:@selector(showCameraAction)]) {
                [self.delgate showCameraAction];
            }
        } break;
        case PhotoAlbum: {
            if ([self.delgate respondsToSelector:@selector(showPhotoAlbumAction)]) {
                [self.delgate showPhotoAlbumAction];
            }
        } break;
        case Emoji: {
            sender.selected = !sender.selected;
            if (sender.selected) {
                [[STEmojiKeyboard keyboard] setTextView:self.contentTextView];
            } else {
                [self.contentTextView setInputView:nil];
            }
            [self.contentTextView reloadInputViews];
            [self.contentTextView becomeFirstResponder];

        } break;

        default:
            break;
    }
}

#pragma mark - <UITextViewDelegate>
- (void)textViewDidEndEditing:(UITextView *)textView {
    self.heightConstraint.constant = [self calculateStudyIntroductionHeight:textView.text];
    if ([self.delgate respondsToSelector:@selector(refreshHeight:)]) {
        [self.delgate refreshHeight:self.contentTextView.height];
    }
}

#pragma mark - 计算高度
- (CGFloat)calculateStudyIntroductionHeight:(NSString *)content {
    return [content heightWithFontSize:14 width:ScreenWidth - 40] + 20;
}


@end
