//
//  CommentListTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/12.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CommentListTableViewCell.h"
#import "MWPhotoBrowser.h"
@interface CommentListTableViewCell ()<MWPhotoBrowserDelegate>
@property (nonatomic,strong) NSMutableArray *browserArray;
@end
@implementation CommentListTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    
    self.bestView = [[BestReplyView alloc] init];
    [self.contentView addSubview:self.bestView];
    [self.bestView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.optionButton.mas_left).offset(-5);
        make.size.mas_equalTo(CGSizeMake(0, 30));
        make.centerY.equalTo(self.optionButton);
    }];
    
    for (UIImageView  *obj in self.attachmentView.subviews) {
        if ([obj isKindOfClass:[UIImageView class]]) {
            obj.userInteractionEnabled = YES;
            UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapImage:)];
            [obj addGestureRecognizer:tap];
        }
    }
}

- (void)tapImage:(UIGestureRecognizer *)tap {
    if (tap.view.tag + 1 > self.replyEntity.attachments.count) {
        return;
    }
    
    [self.browserArray removeAllObjects];
    for (TOAttachmentEntity *att in self.replyEntity.attachments) {
        MWPhoto *photo = [MWPhoto photoWithURL:[NSURL URLWithString:att.fileUrl]];
        [self.browserArray addObject:photo];
    }
    MWPhotoBrowser *browser = [[MWPhotoBrowser alloc] initWithDelegate:self];
    [browser setCurrentPhotoIndex:tap.view.tag];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:browser];
    [self.viewController.navigationController presentViewController:nav animated:YES completion:nil];
}

#pragma mark - <MWPhotoBrowserDelegate>
- (NSUInteger)numberOfPhotosInPhotoBrowser:(MWPhotoBrowser *)photoBrowser
{
    return self.browserArray.count;
}

- (id<MWPhoto>)photoBrowser:(MWPhotoBrowser *)photoBrowser photoAtIndex:(NSUInteger)index
{
    if (index < self.browserArray.count) {
        return [self.browserArray objectAtIndex:index];
    }
    return nil;
}

- (NSString *)photoBrowser:(MWPhotoBrowser *)photoBrowser titleForPhotoAtIndex:(NSUInteger)index
{
    return [NSString stringWithFormat:@"%ld/%ld", index + 1, self.browserArray.count];
}
#pragma mark - 选项按钮
- (IBAction)extensionButtonClickAction:(UIButton *)sender {
    if (self.bestView.width != 0) {
        [UIView animateWithDuration:0.2 animations:^{
            self.bestView.width = 0;
            self.bestView.x = self.optionButton.x;
        }];
    }else {
        [UIView animateWithDuration:0.2 animations:^{
            self.bestView.width = 90;
            self.bestView.x -= 100;
        }];
    }
}

#pragma mark - 赋值
- (void)setReplyEntity:(CustomTOForumReplyEntity *)replyEntity
{
    _replyEntity = replyEntity;
    self.bestView.replyId = _replyEntity.fid;
    if (_replyEntity.isAdminReply) {
        self.issuerNameLabel.customText = @"管理员";
        self.issuerImageView.image = [UIImage imageNamed:@"manager"];
    }else {
        self.issuerNameLabel.customText = [NSString stringWithFormat:@"%@: %@",_replyEntity.replyerPosition,_replyEntity.replyerRealName];
        [self.issuerImageView sd_setImageWithURL:[NSURL URLWithString:_replyEntity.replyerPicture] placeholderImage:ReplaceImage];
    }
    self.issuerDateLabel.text = [BaseViewController formateDate:_replyEntity.replyTime];
    self.commentContentLabel.text = _replyEntity.replyContent;
    self.bestView.isBest = _replyEntity.best;
    self.bestView.indexPath = self.indexPath;
    self.baseImageView.hidden = !_replyEntity.best;
    if (replyEntity.attachments.count > 0) {
        self.layoutAttHeight.constant = 164;
    }else{
        self.layoutAttHeight.constant = 0;
    }
    
    for (NSInteger i = 0; i < replyEntity.attachments.count; i++) {
        TOAttachmentEntity *att = replyEntity.attachments[i];
        UIImageView *imgView = (UIImageView *)[self.attachmentView viewWithTag:i];
        [imgView sd_setImageWithURL:[NSURL URLWithString:att.fileUrl] placeholderImage:REPLACEIMAGE];
    }
    
}

#pragma mark - lazy
- (NSMutableArray *)browserArray
{
    if (!_browserArray) {
        _browserArray = [NSMutableArray array];
    }
    return _browserArray;
}

@end
