//
//  CommentListTableViewCell.h
//  Lighting
//
//  Created by 曹云霄 on 2016/12/12.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "BestReplyView.h"

@interface CommentListTableViewCell : UITableViewCell


/**
 评论人头像
 */
@property (weak, nonatomic) IBOutlet UIImageView *issuerImageView;

/**
 评论人姓名
 */
@property (weak, nonatomic) IBOutlet CustomBorderLabel *issuerNameLabel;

/**
 评论时间
 */
@property (weak, nonatomic) IBOutlet UILabel *issuerDateLabel;

/**
 最佳回复（皇冠）
 */
@property (weak, nonatomic) IBOutlet UIImageView *baseImageView;

/**
 评论内容
 */
@property (weak, nonatomic) IBOutlet UILabel *commentContentLabel;

/**
 选项按钮
 */
@property (weak, nonatomic) IBOutlet UIButton *optionButton;

/**
 下标
 */
@property (nonatomic,strong) NSIndexPath *indexPath;

/**
 最佳回复View
 */
@property (nonatomic,strong) BestReplyView *bestView;

/**
 回复数据源
 */
@property (nonatomic,strong) CustomTOForumReplyEntity *replyEntity;

/**
 附件栏
 */
@property (weak, nonatomic) IBOutlet UIView *attachmentView;

/**
 附件栏高度
 */
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *layoutAttHeight;

@end
