//
//  HomeViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "HomeViewController.h"
#import "FunctionCollectionViewCell.h"
#import "MenuCollectionViewCell.h"
#import "CustomWKWebViewController.h"
#import "ResellerViewController.h"

@interface HomeViewController ()<iCarouselDataSource, iCarouselDelegate,UICollectionViewDataSource,UICollectionViewDelegate,StoreCodeDelegate>

@property (nonatomic,strong) NSTimer *timer;
@property (nonatomic,assign) NSInteger currentIndex;
@property (nonatomic,strong) BannerResponse *homeResponse;
@property (nonatomic,assign) NSInteger timerNumber;

/**
 菜单
 */
@property (nonatomic,strong) NSArray *menuImagesArray;

/**
 功能
 */
@property (nonatomic,strong) NSArray *functionArray;


@end

@implementation HomeViewController

- (void)viewDidAppear:(BOOL)animated
{
    [self startAnimation];
    if (!self.homeResponse) {
        [self getDatasAction];
    }
}

- (void)viewWillDisappear:(BOOL)animated
{
    [self stopAnimation];
}

- (void)viewDidLoad {
    [super viewDidLoad];
 
    [self setUpiCarouselView];
    [self getDatasAction];
    [self setUpCollectionView];
    [self perfectDepartInformation];
}

#pragma mark -获取滚动视图数据
- (void)getDatasAction
{
    WS(weakSelf);
    dispatch_group_t group = dispatch_group_create();
    dispatch_group_enter(group);
    [XBLoadingView showHUDViewWithDefault];
    [HTTP networkRequestWithURL:SERVERREQUESTURL(HOME_DATA) withRequestType:GET withParameter:nil withReturnValueBlock:^(id returnValue) {
        
        dispatch_group_leave(group);
        if (RESULT(returnValue)) {
            weakSelf.homeResponse = [[BannerResponse alloc] initWithDictionary:RESPONSE(returnValue) error:nil];
        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    } withFailureBlock:^(NSError *error) {
        dispatch_group_leave(group);
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
    
    dispatch_group_enter(group);
    [HTTP networkRequestWithURL:SERVERREQUESTURL(BANNERS_SPEED) withRequestType:GET withParameter:nil withReturnValueBlock:^(id returnValue) {
        
        dispatch_group_leave(group);
        if (RESULT(returnValue)) {
            weakSelf.timerNumber = [returnValue[@"spend"] integerValue];
        }
        
    } withFailureBlock:^(NSError *error) {
        dispatch_group_leave(group);
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
    dispatch_group_notify(group, dispatch_get_main_queue(), ^{
        [XBLoadingView hideHUDViewWithDefault];
        [weakSelf.customScorllView reloadData];
    });
}

#pragma mark -设置setUpiCarouselView
- (void)setUpiCarouselView
{
    self.customScorllView.type = iCarouselTypeRotary;
    self.customScorllView.delegate = self;
    self.customScorllView.dataSource = self;
    self.customScorllView.pagingEnabled = YES;
    [self setUpBoxblurImage:self.scrollViewBackView];
}

#pragma mark -完善经销商信息
- (void)perfectDepartInformation
{
    //完善门店编号信息
    if ([BaseViewController isBlankString:[Shoppersmanager manager].shoppers.storeCode]) {
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            [self perfectResellerInformation:^(ResellerViewController *resellerVc) {
                resellerVc.delegate = self;
            }];
        });
    }else {
        [self storeCodeBindedSuccess];
    }
}

#pragma mark -StoreCodeDelegate,门店编号绑定成功
- (void)storeCodeBindedSuccess
{
    //完善省市区信息
    if (![Shoppersmanager manager].shoppers.isHasStoreAddress) {
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            [self perfectStoreLocationInformation];
        });
    }
}

#pragma mark -设置setUpCollectionView
- (void)setUpCollectionView
{
    self.menuFlowLayout.sectionInset = UIEdgeInsetsMake(20, 20, 20, 20);
    self.menuFlowLayout.minimumInteritemSpacing = 10;
    self.functionFlowLayout.sectionInset = UIEdgeInsetsMake(0, 10, 0, 10);
    self.functionFlowLayout.minimumInteritemSpacing = 10;
}

#pragma mark -布局加载完成
- (void)viewDidLayoutSubviews
{
    self.menuFlowLayout.itemSize = CGSizeMake((ScreenWidth-70)/4.0, self.menuCollectionView.height-40);
    self.functionFlowLayout.itemSize = CGSizeMake((ScreenWidth-60)/5.0, self.functionCollectionView.height);
}

#pragma mark -添加模糊
- (void)setUpBoxblurImage:(UIImageView *)imageView
{
    UIBlurEffect *blurEffect = [UIBlurEffect effectWithStyle:UIBlurEffectStyleLight];
    UIVisualEffectView *effectView = [[UIVisualEffectView alloc] initWithEffect:blurEffect];
    effectView.frame = imageView.bounds;
    [imageView addSubview:effectView];
}

#pragma mark -<iCarouselDataSource,iCarouselDelegate>
- (NSInteger)numberOfItemsInCarousel:(iCarousel *)carousel
{
    return self.homeResponse.list.count;
}

- (UIView *)carousel:(iCarousel *)carousel viewForItemAtIndex:(NSInteger)index reusingView:(nullable UIView *)view
{
    if (view == nil)
    {
        view = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, ScreenWidth*0.7, ScreenHeight*0.35-20)];
        UIImageView *imageView = (UIImageView *)view;
        TOBannerEntity *entity = self.homeResponse.list[index];
        [imageView sd_setImageWithURL:[NSURL URLWithString:entity.attachment] placeholderImage:REPLACEIMAGE];
        view.contentMode = UIViewContentModeScaleToFill;
        [view setMyCorner:5];
    }
    return view;
}

- (void)carouselCurrentItemIndexDidChange:(iCarousel *)carousel
{
    NSInteger index = carousel.currentItemIndex;
    self.currentIndex = index;
    TOBannerEntity *entity = self.homeResponse.list[carousel.currentItemIndex];
    [self.scrollViewBackView sd_setImageWithURL:[NSURL URLWithString:entity.attachment] placeholderImage:REPLACEIMAGE];
}

- (void)carousel:(iCarousel *)carousel didSelectItemAtIndex:(NSInteger)index
{
    TOBannerEntity *entity = self.homeResponse.list[carousel.currentItemIndex];
    if (![[self class] isBlankString:entity.url]) {
        CustomWKWebViewController *webView = [[CustomWKWebViewController alloc] init];
        webView.urlString = entity.url;
        [self presentViewController:webView animated:YES completion:nil];
    }
}


#pragma mark -<UICollectionViewDelegate,UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    if ([collectionView isEqual:self.menuCollectionView]) {
        return self.menuImagesArray.count;
    }
    return self.functionArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    if ([collectionView isEqual:self.menuCollectionView]) {
        MenuCollectionViewCell *menuCell= [collectionView dequeueReusableCellWithReuseIdentifier:@"MenuCollectionViewCell" forIndexPath:indexPath];
        menuCell.menuImageView.image = TCImage(self.menuImagesArray[indexPath.item]);
        return menuCell;
    }
    FunctionCollectionViewCell *functionCell = [collectionView dequeueReusableCellWithReuseIdentifier:@"FunctionCollectionViewCell" forIndexPath:indexPath];
    [functionCell.functionButton setTitle:self.functionArray[indexPath.item] forState:UIControlStateNormal];
    return functionCell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if ([collectionView isEqual:self.menuCollectionView]) {
        switch (indexPath.item) {
            case ExperienceCentre:
            {
                [Notification postNotificationName:OPENFOLLOWHEARTVC object:nil];
            }
                break;
            case ProductLibrary:
            {
                [SHARED_APPDELEGATE.tabBarController setSelectedIndex:9];
            }
                break;
            case StudyGuides:
            {
                if ([[Shoppersmanager manager].shoppers.employee.userKey rangeOfString:@"学习人员"].location == NSNotFound) {
                    [XBLoadingView showHUDViewWithText:@"没有学习中心权限,无法进入"];return;
                }
                [SHARED_APPDELEGATE.tabBarController setSelectedIndex:12];
            }
                break;
            case CustomerInformation:
            {
                [SHARED_APPDELEGATE.tabBarController switchSelectedIndex:CUSTOMER];
                [SHARED_APPDELEGATE.tabBarController setSelectedIndex:3];
            }
                break;
                
            default:
                break;
        }
    }
}


#pragma mark -启动定时器
- (void)startAnimation
{
    if (!_timer)
    {
        NSInteger number = self.timerNumber?self.timerNumber:5;
        self.timer = [NSTimer timerWithTimeInterval:number
                                             target:self
                                           selector:@selector(refreshItem)
                                           userInfo:nil
                                            repeats:YES];
        
        [[NSRunLoop mainRunLoop] addTimer:_timer forMode:NSRunLoopCommonModes];
    }
}

#pragma mark -刷新item
- (void)refreshItem
{
    [self.customScorllView  scrollToItemAtIndex:self.currentIndex+1 animated:YES];
}

#pragma mark -停止定时器
- (void)stopAnimation
{
    [_timer invalidate];
    _timer = nil;
}

#pragma mark -lazy
- (NSArray *)menuImagesArray
{
    if (!_menuImagesArray ) {
        _menuImagesArray = @[@"ExperienceCentre",@"ProductLibrary",@"StudyGuides",@"CustomerInformation"];
    }
    return _menuImagesArray;
}

- (NSArray *)functionArray
{
    if (!_functionArray) {
        _functionArray  = @[@"欧普O2O销售平台",@"活动信息一手掌握",@"场景体验一站式购买",@"创新的在线学习体验",@"灯光设计定制服务"];
    }
    return _functionArray;
}



@end
