//
//  ShareGoodsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/6/3.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShareGoodsViewController.h"

@interface ShareGoodsViewController ()

@end

@implementation ShareGoodsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
}

#pragma mark - 压缩图片
- (void)setShareImage:(UIImage *)shareImage
{
    _shareImage = [UIImage imageWithData:UIImageJPEGRepresentation(shareImage, 0.2)];
}

#pragma mark -分享
- (IBAction)shareWeiChatAntWeiboAction:(UIButton *)sender {
    
    WS(weakSelf);
    switch (self.type) {
            case SHARE_GOODS:
        {
   
            
            NSData *imageData = UIImageJPEGRepresentation(self.shareImage, 0.5);
            NSString *goodsID = [self.shareID substringToIndex:[self.shareID length]-1];
            NSDictionary *parameterDict = [NSDictionary dictionaryWithObjectsAndKeys:[goodsID substringToIndex:self.shareID.length-1],@"goodsIds",@"",@"title",@"",@"remark",nil];
            XBLoadingView *progressView = [XBLoadingView showHUDViewProgressLabel:@"上传图片中"];
            [HTTP uploadImageWithURL:SERVERREQUESTURL(SHARE) withRequestType:ZERO withImageDatas:imageData withParameter:parameterDict withReturnValueBlock:^(id returnValue) {
                if (RESULT(returnValue)) {
                    NSString *shareWeb = RESPONSE(returnValue)[@"url"];
                    UIAlertController *alertView = [UIAlertController alertControllerWithTitle:@"提示" message:@"请输入分享标题" preferredStyle:UIAlertControllerStyleAlert];
                    [alertView addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
                        
                        [weakSelf callSharePlatform:shareWeb withPlatformTag:sender customTitle:nil];
                    }]];
                    [alertView addAction:[UIAlertAction actionWithTitle:@"确认" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                        UITextField *textField = [alertView.textFields firstObject];
                        [weakSelf callSharePlatform:shareWeb withPlatformTag:sender customTitle:textField.text];
                    }]];
                    [alertView addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                        textField.placeholder = @"请输入";
                    }];
                    [self presentViewController:alertView animated:YES completion:nil];
                }else
                {
                    [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
                }
            }withprogressBlock:^(double progress) {
                if (progress >= 1) {
                    dispatch_async(dispatch_get_main_queue(), ^{
                        progressView.labelText = @"上传成功";
                        [progressView hide:YES];
                    });
                }else{
                    progressView.progress = progress;
                }
                
            } withFailureBlock:^(NSError *error) {
                [XBLoadingView hideHUDViewWithDefault];
                [XBLoadingView showHUDViewWithText:error.localizedDescription];
            }];
        }
            break;
            case SHARE_ORDER:
        {
            [XBLoadingView showHUDViewWithDefault];
            NSString *shareOrderString = [NSString stringWithFormat:@"%@/%@",SHAREORDERBILL,self.shareID];
            [HTTP networkWithDictionaryRequestWithURL:SERVERREQUESTURL(shareOrderString) withRequestType:ZERO withParameter:nil withReturnValueBlock:^(id returnValue) {
                
                [XBLoadingView hideHUDViewWithDefault];
                if (RESULT(returnValue)) {
                    [weakSelf callSharePlatform:RESPONSE(returnValue)[@"url"] withPlatformTag:sender customTitle:nil];
                }else
                {
                    [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
                }
                
            } withFailureBlock:^(NSError *error) {
                [XBLoadingView hideHUDViewWithDefault];
                [XBLoadingView showHUDViewWithText:error.localizedDescription];
            }];
        }
            break;
            case SHARE_INVITATION:
        {
            [XBLoadingView showHUDViewWithDefault];
            NSString *string = [NSString stringWithFormat:SHAREINVITATION,self.shareID];
            [HTTP networkWithDictionaryRequestWithURL:SERVERREQUESTURL(string) withRequestType:ZERO withParameter:nil withReturnValueBlock:^(id returnValue) {
                
                [XBLoadingView hideHUDViewWithDefault];
                if (RESULT(returnValue)) {
                    [weakSelf callSharePlatform:RESPONSE(returnValue)[@"url"] withPlatformTag:sender customTitle:nil];
                }else
                {
                    [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
                }
                
            } withFailureBlock:^(NSError *error) {
                [XBLoadingView hideHUDViewWithDefault];
                [XBLoadingView showHUDViewWithText:error.localizedDescription];
            }];
        }
            break;
        default:
            break;
    }
}

#pragma mark - 调用分享
- (void)callSharePlatform:(NSString *)shareWeb withPlatformTag:(UIButton *)sender customTitle:(NSString *)title
{
    [UMSocialGlobal shareInstance].isUsingHttpsWhenShareContent = NO;
    //创建分享消息对象
    UMSocialMessageObject *messageObject = [UMSocialMessageObject messageObject];
    //设置文本
    messageObject.text = @"欧立方一键分享";
    switch (self.type) {
        case SHARE_GOODS:
        {
            UMShareWebpageObject *shareObject = [UMShareWebpageObject shareObjectWithTitle:[BaseViewController isBlankString:title]?@"欧立方体验中心一键分享":title descr:nil thumImage:self.shareImage];
            shareObject.webpageUrl = shareWeb;
            messageObject.shareObject = shareObject;
        }
            
            break;
        case SHARE_ORDER:
        {
            UMShareWebpageObject *shareObject = [UMShareWebpageObject shareObjectWithTitle:@"欧立方订单分享" descr:nil thumImage:[UIImage imageNamed:@"shareIcon"]];
            shareObject.webpageUrl = shareWeb;
            messageObject.shareObject = shareObject;

        }
            break;
        case SHARE_INVITATION:
        {
            UMShareWebpageObject *shareObject = [UMShareWebpageObject shareObjectWithTitle:@"欧立方论坛分享" descr:nil thumImage:[UIImage imageNamed:@"shareIcon"]];
            shareObject.webpageUrl = shareWeb;
            messageObject.shareObject = shareObject;

        }
            break;
            
        default:
            break;
    }

    switch (sender.tag) {
        case 100: //微信好友
        {
            [[UMSocialManager defaultManager] shareToPlatform:UMSocialPlatformType_WechatSession messageObject:messageObject currentViewController:self completion:^(id data, NSError *error) {
                if (error) {
                    NSLog(@"************Share fail with error %@*********",error);
                }else{
                    [XBLoadingView showHUDViewWithSuccessText:@"分享微信好友成功" completeBlock:nil];
                }
            }];
        }
            break;
        case 101://微信朋友圈
        {
            [[UMSocialManager defaultManager] shareToPlatform:UMSocialPlatformType_WechatTimeLine messageObject:messageObject currentViewController:self completion:^(id data, NSError *error) {
                if (error) {
                    NSLog(@"************Share fail with error %@*********",error);
                }else{
                    [XBLoadingView showHUDViewWithSuccessText:@"分享微信朋友圈成功" completeBlock:nil];
                }
            }];
        }
            break;
        case 102://新浪微博
        {
            [[UMSocialManager defaultManager] shareToPlatform:UMSocialPlatformType_Sina messageObject:messageObject currentViewController:self completion:^(id data, NSError *error) {
                if (error) {
                    NSLog(@"************Share fail with error %@*********",error);
                }else{
                    [XBLoadingView showHUDViewWithSuccessText:@"分享新浪微博成功" completeBlock:nil];
                }
            }];
        }
            break;
    }

}


@end
