//
//  ShoppingTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/29.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShoppingTableViewCell.h"

@implementation ShoppingTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
    
    [self uiConfigAction];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.ClinchPriceBackView.layer.masksToBounds = YES;
    self.ClinchPriceBackView.layer.cornerRadius = kCornerRadius;
    self.clinchTextfield.delegate = self;
}

#pragma mark -赋值
- (void)setModel:(ShopcarModel *)model
{
    _model = model;
    self.selectedButton.selected = _model.isSelected;
    NSArray *images = [_model.goods.pictures componentsSeparatedByString:@","];
    [self.goodsImageView sd_setImageWithURL:[NSURL URLWithString:[images firstObject]] placeholderImage:REPLACEIMAGE];
    self.goodsInformationLabe.text = _model.goods.name;
    self.specifications.text = _model.goods.size;
    self.goodsCode.text = _model.goods.code;
    self.tagsPriceLabe.text = [_model.goods.tagPrice stringValue];
    self.clinchTextfield.text = [NSString stringWithFormat:@"%.2f",[_model.costPrice floatValue]?[_model.costPrice floatValue]:[_model.goods.tagPrice floatValue]];
    self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",_model.goodsNum];
    if ([_model.costPrice integerValue] == 0) {
        _model.costPrice = _model.goods.tagPrice;
    }
    self.productPriceLabe.text = [NSString stringWithFormat:@"￥%.2f",[self.goodsNumbersLabe.text integerValue]*[_model.costPrice floatValue]];;
}

#pragma mark -增加或者减少商品
- (IBAction)reduceAndaddButtonClick:(UIButton *)sender {
    
    //sender.tag == 100   减少
    //sender.tag == 101   增加
    NSInteger goodsNumber = [self.goodsNumbersLabe.text integerValue];
    switch (sender.tag) {
        case 100://减少
        {
            if (goodsNumber <= 1) {
                if (self.promptStringBlock) {
                    self.promptStringBlock(@"个数不能小于1");
                }
                //不能小于1
                return;
            }
            goodsNumber --;
//          self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",goodsNumber];
        }
            break;
        case 101://增加
        {
            if (goodsNumber >= [_model.goods.number integerValue]) {
                //不能大于库存
                if (self.promptStringBlock) {
                    self.promptStringBlock(@"个数不能大于库存");
                }
                return;
            }
            goodsNumber ++;
//          self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",goodsNumber];
        }
            break;
        default:
            break;
    }
    //改变价格
    WS(weakSelf);
    self.productPriceLabe.text = [NSString stringWithFormat:@"￥%.2f",[self.goodsNumbersLabe.text integerValue]*[self.clinchTextfield.text floatValue]];
    if ([self.delegate respondsToSelector:@selector(ChangeGoodsNumber:WithcostPrice:Withcellindex:returnValue:)]) {
        [self.delegate ChangeGoodsNumber:goodsNumber WithcostPrice:[self.clinchTextfield.text floatValue]Withcellindex:_cellindex returnValue:^(id value) {
            if ([value isKindOfClass:[NSDictionary class]]) {
                if ([value[@"code"] isEqualToNumber:@0]) {
                weakSelf.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",goodsNumber];
                }
            }
        }];
    }
}


#pragma mark -商品选中
- (IBAction)selectedButtonClick:(UIButton *)sender {
    
    if (self.returnCellblock) {
        
        self.returnCellblock(_cellindex);
    }
    sender.selected = !sender.selected;
}


#pragma mark -成交价完成修改
- (BOOL)textFieldShouldEndEditing:(UITextField *)textField
{
    Shoppersmanager *user = [Shoppersmanager manager];
    if (![self isPureInt:textField.text]) {
        if (self.promptStringBlock) {
            self.promptStringBlock(@"输入格式错误");
        }
    } else if ([textField.text floatValue] < [user.Shoppers.lowestDiscount floatValue]/100 * [self.model.goods.tagPrice floatValue])
    {
        if (self.promptStringBlock) {
            self.promptStringBlock(@"当前价格低于你的权限范围!");
        }
    }
    else
    {
        //改变价格
        self.productPriceLabe.text = [NSString stringWithFormat:@"￥%.2f",[self.goodsNumbersLabe.text integerValue]*[textField.text floatValue]];
        
        if ([self.delegate respondsToSelector:@selector(ChangeGoodsNumber:WithcostPrice:Withcellindex:returnValue:)]) {
            [self.delegate ChangeGoodsNumber:[self.goodsNumbersLabe.text integerValue] WithcostPrice:[self.clinchTextfield.text floatValue]Withcellindex:_cellindex returnValue:^(id value) {
            }];
        }
    }
    return YES;
}


#pragma mark - 判断是否是浮点数
- (BOOL)isPureInt:(NSString*)string{
    NSScanner* scan = [NSScanner scannerWithString:string];
    float val;
    return[scan scanFloat:&val] && [scan isAtEnd];
}



@end
