//
//  ProductLibraryView.m
//  Lighting
//
//  Created by mac on 16/5/11.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ProductLibraryView.h"


@implementation ProductLibraryView
/**
 *  初始化商品数据源数组
 */
- (NSMutableArray *)datasArray
{
    if (_datasArray == nil) {
        
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}
/**
 *  初始化筛选数据源
 */
- (NSMutableArray *)arrayData
{
    if (_arrayData == nil) {
        
        _arrayData = [NSMutableArray array];
    }
    return _arrayData;
}
/**
 *  初始化复选模型
 */
- (GoodsCondition *)condtionModel
{
    if (!_condtionModel) {
        _condtionModel = [[GoodsCondition alloc]init];
    }
    return _condtionModel;
}

- (void)viewDidLoad {
    [self initdata];
    [self initSubView];
  
    

}

-(void)initdata
{
    self.arrayData=[[NSMutableArray alloc]init];
    self.nameData=[[NSMutableArray alloc]initWithObjects:@"风格",@"类型",@"空间",@"材质",@"价格",nil];
    self.cellArray=[[NSMutableArray alloc]init];
    self.showSection=[[NSMutableArray alloc]init];
    self.typeBtnArray=[[NSMutableArray alloc]init];
    self.sectionBtnArray=[[NSMutableArray alloc]init];
    self.cellBtnArray=[[NSMutableArray alloc]init];
    self.indexPage = 1;
    self.selectedIndex=100;
    
}
- (void)uiConfigAction
{
    //下拉刷新
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        
       
            //分页数据
            DataPage *Newpage = [[DataPage alloc]init];
            Newpage.page = 1;
            Newpage.rows = KROWS;
            self.condtionModel.page = Newpage;
            self.indexPage = 1;
            //搜索
            if (self.selectedCode) {
                switch (self.selectedIndex) {
                    case 100://风格
                    {
                        self.condtionModel.styleEquals = self.selectedCode;
                    }
                        break;
                    case 101://类型
                    {
                        self.condtionModel.categoryEquals = self.selectedCode;
                    }
                        break;
                    case 102://空间
                    {
                        self.condtionModel.spaceEquals = self.selectedCode;
                    }
                        break;
                    case 103://材质
                    {
                        self.condtionModel.materialEqueals = self.selectedCode;
                    }
                        break;
                    case 104://价格
                    {
                        //价格字符串切割
                        NSArray *spacrArray = [self.selectedCode componentsSeparatedByString:@"到"];
                        self.condtionModel.startprice = [NSNumber numberWithInteger:[[spacrArray objectAtIndex_opple:0] integerValue]];
                        self.condtionModel.endprice = [NSNumber numberWithInteger:[[spacrArray objectAtIndex_opple:1] integerValue]];
                        self.condtionModel.categoryEquals = self.selectedCode;
                    }
                        break;
                        
                    default:
                        break;
                }
                
           }
            [self.collectionView.mj_footer resetNoMoreData];
            [self getScreeningdatasisRemoveArray:YES];
            [self getGoodsListDatasisRemove:YES Withobject:self.condtionModel];
        
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.collectionView.mj_header = headerRefresh;
    [self.collectionView.mj_header beginRefreshing];
    
    //上拉加载
    self.collectionView.mj_footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        
        
            if (self.indexPage ++ > self.totalPages) {
                [self.collectionView.mj_footer endRefreshingWithNoMoreData];
            }else
            {
                //分页数据
                DataPage *Newpage = [[DataPage alloc]init];
                Newpage.page = self.indexPage ++;
                Newpage.rows = KROWS;
                self.condtionModel.page = Newpage;
                //搜索
                if (self.selectedCode) {
                    self.condtionModel.categoryEquals = self.selectedCode;
                }
                [self getGoodsListDatasisRemove:NO Withobject:self.condtionModel];
            }
        
    }];

}

#pragma mark -获取商品列表数据
- (void)getGoodsListDatasisRemove:(BOOL)remove Withobject:(GoodsCondition *)conditon
{

    [self getGoodsListdatas:conditon returnResponse:^(GoodsResponse *response) {
        if (response.goodsEntity.count == 0) {
            
            [self ErrorMBProgressView:@"暂无数据"];
            
        }else
        {
            if (remove) {
                [self.datasArray removeAllObjects];
            }
            for (TOGoodsEntity *model in response.goodsEntity) {
                [self.datasArray addObject:model];
            }
            [self.collectionView reloadData];
             [self.seceneTableView reloadData];
        }
    }];
}

#pragma mark -获取产品筛选数据
- (void)getScreeningdatasisRemoveArray:(BOOL)remove

{

    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/goods/getGoodsFilter"] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {

        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            if (remove) {
                [self.arrayData removeAllObjects];
            }

            GoodsFilter *goodsStyle = [[GoodsFilter alloc]initWithDictionary:returnValue[@"data"] error:nil];
            self.goodsFilter=goodsStyle;
            switch (self.selectedIndex) {
                case 100:
                    //            风格
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.styles];
                    
                    break;
                case 101:
                    //            类型
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.categories];
                    break;
                case 102:
                    //            空间
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.space];
                    break;
                case 103:
                    //            材质
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.material];
                    break;
                case 104:
                    //            价格
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.price];
                    break;
                    
                default:
                    break;
            }
            
            [self.seceneTableView reloadData];
        }
        else
            {
            [self ErrorMBProgressView:returnValue[@"message"]];
            }

    } WithErrorCodeBlock:^(id errorCodeValue) {

    } WithFailureBlock:^(id error) {

        NSLog(@"%@",error);
    }];
}



#pragma mark -获取商品列表数据
- (void)getGoodsListdatas:(GoodsCondition *)conditon returnResponse:(void(^)(GoodsResponse *))finish
{

    [self CreateMBProgressHUDLoding];
     [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/goods/query"] WithRequestType:0 WithParameter:conditon WithReturnValueBlock:^(id returnValue) {

        [self RemoveMBProgressHUDLoding];
        [self endRefreshingForTableView:self.collectionView];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {

            GoodsResponse *sponse = [[GoodsResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            //返回结果
            finish(sponse);
        }
        else
            {
            [self ErrorMBProgressView:@"暂无数据"];
            }

    } WithErrorCodeBlock:^(id errorCodeValue) {

    } WithFailureBlock:^(id error) {
         [self endRefreshingForTableView:self.collectionView];
        [self RemoveMBProgressHUDLoding];
    }];
}
-(void)initSubView
{
    for (int i=0; i<self.nameData.count; i++) {
        if (i !=5) {
            UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
            btn.frame=CGRectMake(ScreenWidth-250, 52+i*50, 100, 46) ;
            btn.backgroundColor=[UIColor whiteColor];
            [btn setTitle:[self.nameData objectAtIndex:i] forState:UIControlStateNormal];
             btn.contentEdgeInsets = UIEdgeInsetsMake(0, 40, 0, 0);
            [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
            [btn addTarget:self action:@selector(selectedType:) forControlEvents:UIControlEventTouchUpInside];
            if (i==0) {
                btn.backgroundColor=RGB(79, 153, 217, 1);
                [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
            }else
            {
                 btn.backgroundColor=RGB(225, 225, 225, 1);
                 [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
            }
            btn.tag=100 +i;
            btn.layer.masksToBounds = YES;
            btn.layer.cornerRadius = 20;
            [self.typeBtnArray addObject:btn];
            [self.view addSubview:btn];
        }
       
    }
    self.subView=[[UIView alloc]initWithFrame:CGRectMake(100, 50, ScreenWidth-300, ScreenHeight-200)];
    self.subView.backgroundColor=[UIColor whiteColor];
    [self.view  addSubview:self.subView];

    //点击手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(DismissScreenView:)];
    tap.delegate = self;
    tap.cancelsTouchesInView = NO;
    [[UIApplication sharedApplication].keyWindow addGestureRecognizer:tap];
    [self initSubViews];
   
    
}


-(void)initSubViews
{
    self.headerView=[[UIView alloc]initWithFrame:CGRectMake(0, 0, self.subView.frame.size.width-100, 50)];
    self.headerView.backgroundColor=RGB(225, 225, 225, 1);
    [self.subView addSubview:self.headerView];
    UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame=CGRectMake(10, 10, 30, 30);
    [btn setBackgroundImage:[UIImage imageNamed:@"Folder"] forState:UIControlStateNormal];
    [self.headerView addSubview:btn];
    UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(45, 10, 100, 30)];
    lable.text=@"选择产品";
    [self.headerView addSubview:lable];
    //输入框背景
    UIImageView *backView = [[UIImageView alloc]initWithFrame:CGRectMake(self.headerView.frame.size.width-300, 10,250, 30)];
    backView.userInteractionEnabled=YES;
    [backView setImage:[UIImage imageNamed:@"line"]];
    [self.headerView addSubview:backView];
    //搜索图标
    UIButton *searchBtn = [[UIButton alloc]initWithFrame:CGRectMake(5, 0, 35, 25)];
    searchBtn.backgroundColor=RGB(225, 225, 225, 1);
    [searchBtn setBackgroundImage:[UIImage imageNamed:@"search"] forState:UIControlStateNormal] ;
    [searchBtn addTarget:self action:@selector(searchProduct:) forControlEvents:UIControlEventTouchUpInside];
    [backView addSubview:searchBtn];

    
    //输入框
   self.searchTextField = [[UITextField alloc]initWithFrame:CGRectMake(50, 0, backView.frame.size.width-50, 29)];
    self.searchTextField.borderStyle = UITextBorderStyleNone;
    self.searchTextField.placeholder = @" 请输入产品关键字";
    self.searchTextField.font = [UIFont systemFontOfSize:12];
    self.searchTextField.returnKeyType = UIReturnKeySearch;
    [backView addSubview:self.searchTextField];
//
    
    self.seceneTableView=[[UITableView alloc]initWithFrame:CGRectMake( self.headerView.frame.size.width, 0, 100, self.subView.frame.size.height)];
    self.seceneTableView.delegate=self;
    self.seceneTableView.dataSource=self;
    self.seceneTableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    self.seceneTableView.tableHeaderView=nil;
    [self.subView addSubview:self.seceneTableView];
    
 
    //确定是水平滚动，还是垂直滚动
    UICollectionViewFlowLayout *flowLayout=[[UICollectionViewFlowLayout alloc] init];
    [flowLayout setScrollDirection:UICollectionViewScrollDirectionVertical];
    
    self.collectionView=[[UICollectionView alloc] initWithFrame:CGRectMake( 0, 50, self.headerView.frame.size.width, self.subView.frame.size.height-50) collectionViewLayout:flowLayout];
    self.collectionView.dataSource=self;
    self.collectionView.delegate=self;
    [self.collectionView setBackgroundColor:RGB(241, 241, 241, 1)];
    //注册Cell，必须要有
    [self.collectionView registerClass:[ProductCollectionPictureCell class] forCellWithReuseIdentifier:@"UICollectionViewCell"];
    
    [self.subView addSubview:self.collectionView];
    [self uiConfigAction];
}
-(void)selectedType:(UIButton *)sender
{
   
    for (UIButton *btn in self.typeBtnArray) {
        btn.backgroundColor=RGB(225, 225, 225, 1);
       [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    }
    sender.backgroundColor=RGB(79, 153, 217, 1);
    [sender setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
//    btn.backgroundColor=RGB(79, 153, 217, 1);
//    btn.backgroundColor=RGB(225, 225, 225, 1);
    self.selectedIndex=sender.tag;
            switch (sender.tag) {
                case 100:
                    //            风格
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.styles];
                    
                    break;
                case 101:
                    //            类型
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.categories];
                    break;
                case 102:
                    //            空间
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.space];
                    break;
                case 103:
                    //            材质
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.material];
                    break;
                case 104:
                    //            价格
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.price];
                    break;
              
                default:
                    break;
            }
    [self.seceneTableView reloadData];
    [self.collectionView.mj_header beginRefreshing];
}
-(void)didSelectSection:(UIButton *)sender
{
    [self.sectionBtnArray removeAllObjects];
    [self.sectionBtnArray addObject:sender.titleLabel.text];
    sender.backgroundColor=RGB(221, 221, 221, 1);
   
    switch (self.selectedIndex) {
        case 100://风格
        {
            self.selectedCode = [[self.arrayData objectAtIndex_opple:sender.tag-100] typecode] ;
            [self.collectionView.mj_header beginRefreshing];
        }
            break;
        case 101://类型
        {
            if ([[NSString stringWithFormat:@"%d",sender.tag-100 ]isEqualToString:[NSString stringWithFormat:@"%@",[self.showSection firstObject]]]) {
                [self.cellArray removeAllObjects ];
                [self.showSection removeAllObjects];
                [self.seceneTableView reloadData];
            }else
            {
                [self.cellArray removeAllObjects ];
                [self.showSection removeAllObjects];
                self.selectedCode = [[self.arrayData objectAtIndex_opple:sender.tag-100] fid] ;
                [self.collectionView.mj_header beginRefreshing];
                self.cellArray=[NSMutableArray arrayWithArray:[[self.arrayData objectAtIndex_opple:sender.tag-100] children]];
                [self.showSection addObject:[NSString stringWithFormat:@"%d",sender.tag-100]];
                [self.seceneTableView reloadData];
            }
          
        }
            break;
        case 102://空间
        {
         self.selectedCode = [[self.arrayData objectAtIndex_opple:sender.tag-100] typecode] ;
        [self.collectionView.mj_header beginRefreshing];
        }
            break;
        case 103://材质
        {
            self.selectedCode = [[self.arrayData objectAtIndex_opple:sender.tag-100] typecode] ;
            [self.collectionView.mj_header beginRefreshing];

        }
            break;
        case 104://价格
        {
            self.selectedCode = [[self.arrayData objectAtIndex_opple:sender.tag-100] typecode] ;
            [self.collectionView.mj_header beginRefreshing];
        }
            break;
            
        default:
            break;
    }

}
#pragma mark -- UICollectionViewDataSource
//定义展示的UICollectionViewCell的个数
-(NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
      return self.datasArray.count;

}


//每个UICollectionView展示的内容
-(UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString * CellIdentifier = @"UICollectionViewCell";
    ProductCollectionPictureCell * cell = (ProductCollectionPictureCell*)[collectionView dequeueReusableCellWithReuseIdentifier:CellIdentifier forIndexPath:indexPath];
    NSArray *imageArray = [[[self.datasArray objectAtIndex_opple:indexPath.item] pictures] componentsSeparatedByString:@","];
    [cell.productImageView sd_setImageWithURL:[NSURL URLWithString:[imageArray firstObject]] placeholderImage:REPLACEIMAGE];
    [cell.productImageView sd_setImageWithURL:[NSURL URLWithString:[imageArray firstObject]] placeholderImage:REPLACEIMAGE];
    cell.productDesce.text=[[self.datasArray objectAtIndex_opple:indexPath.item] name];

   TOGoodsEntity *model = [self.datasArray objectAtIndex_opple:indexPath.item];
    cell.productPrice.text = [NSString stringWithFormat:@"￥%@",[[[self.datasArray objectAtIndex_opple:indexPath.item] tagPrice] stringValue]];
    cell.productParameter.text=[NSString stringWithFormat:@"%@ %@ ",model.code,model.size];
    cell.productModel=[self.datasArray objectAtIndex_opple:indexPath.item];

    return cell;
}
#pragma mark --UICollectionViewDelegateFlowLayout
//定义每个Item 的大小
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(190, 150);
}

//定义每个UICollectionView 的边距
-(UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout insetForSectionAtIndex:(NSInteger)section
{
    return UIEdgeInsetsMake(10, 10, 20, 20);
}
//定义每个UICollectionView 的纵向间距
-(CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section{
    return 2;
}

#pragma mark --UICollectionViewDelegate

//UICollectionView被选中时调用的方法
-(void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    ProductCollectionPictureCell * cell = (ProductCollectionPictureCell *)[collectionView cellForItemAtIndexPath:indexPath];
    if ([self.delegate respondsToSelector:@selector(addProductImage:productModel:)]) {
        
        [self.delegate addProductImage:cell.productImageView.image productModel:cell.productModel];
    }

}

//返回这个UICollectionView是否可以被选择
-(BOOL)collectionView:(UICollectionView *)collectionView shouldSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    return YES;
}

#pragma mark - 协议方法
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 50;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return self.arrayData.count;;
}
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView * view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, tableView.frame.size.width, 50)];
    view.backgroundColor = [UIColor whiteColor];
    NSString *str=[[NSString alloc]init];
    if (self.selectedIndex==101) {
        str=[NSString stringWithFormat:@"%@",[[self.arrayData objectAtIndex_opple:section] name]];
    }else
    {
       str=[NSString stringWithFormat:@"%@",[[self.arrayData objectAtIndex_opple:section] typename]];
    }
    
    UIButton *btn=[[ UIButton alloc]initWithFrame:CGRectMake(0, 0, view.frame.size.width, view.frame.size.height-1)];
    [btn setTitle:str forState:UIControlStateNormal];
    [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    if ([str isEqualToString:[self.sectionBtnArray firstObject]]) {
        btn.backgroundColor=RGB(221, 221, 221, 1);
        [btn setTitleColor:RGB(79, 153, 217, 1) forState:UIControlStateNormal];
    }else
    {
        btn.backgroundColor=[UIColor whiteColor];
        [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    }
    btn.tag=section+100;
    btn.titleLabel.font=[UIFont systemFontOfSize:15];
    [btn addTarget:self action:@selector(didSelectSection:) forControlEvents:UIControlEventTouchUpInside];
    [view addSubview:btn];
    UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(0, view.frame.size.height-1, view.frame.size.width, 1)];
    lable.backgroundColor=[UIColor grayColor];
    [view addSubview:lable];
    return view;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (self.selectedIndex==101) {//类型
        if ([self.showSection containsObject:[NSString stringWithFormat:@"%d",section]]) {
            return self.cellArray.count;
        }else
        {
            return 0;
        }
    }else
    {
        return 0;
    }
    
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([tableView isEqual:self.seceneTableView])
    {
        return 50;
    }else
    {
        return 150;
    }
    
    
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
           static NSString *cellID = @"ChooseTansferCell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
        if (cell == nil) {
            cell = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
//            cell.selectionStyle = UITableViewCellSelectionStyleNone;

        }
    cell.backgroundColor=[UIColor whiteColor];
    cell.textLabel.textColor=[UIColor blackColor];
    
    if ([[self.cellArray objectAtIndex_opple:indexPath.row]isKindOfClass:[GoodsCategory class]]) {
        cell.textLabel.text=[[self.cellArray objectAtIndex_opple:indexPath.row] name];
        if ([cell.textLabel.text isEqualToString:[self.cellBtnArray firstObject]]) {
            cell.backgroundColor=RGB(221, 221, 221, 1);
            cell.textLabel.textColor=RGB(79, 153, 217, 1);
        }
        cell.textLabel.textAlignment=NSTextAlignmentCenter;
    }//        05产品库-详情_03
           return cell;
        
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self.cellBtnArray removeAllObjects];
    self.selectedCode = [[self.cellArray objectAtIndex_opple:indexPath.row] fid] ;
    [self.cellBtnArray addObject:[[self.cellArray objectAtIndex_opple:indexPath.row] name]];

    [self.collectionView.mj_header beginRefreshing];
    
}
//产品搜索
-(void)searchProduct:(UIButton *)sender
{
    if (self.searchTextField.text==nil||[self.searchTextField.text isEqualToString:@""]) {
        [self  SHOWPrompttext:@"请先输入搜索关键字"];
    }else
    {
    self.condtionModel.nameLike=self.searchTextField.text;
    [self.collectionView.mj_header beginRefreshing];
 
    }
    
}

-(void)DismissScreenView:(UITapGestureRecognizer*)sender{
    CGPoint point = [sender locationInView:self.view];
    if (point.x<100 || point.x >ScreenWidth-150||point.y<50||point.y>ScreenHeight-150) {
        
        if (self) {
            if ([self.delegate respondsToSelector:@selector(restProductBtnImage)]) {
                [self.delegate restProductBtnImage];
            }
           
        }
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
