//
//  screeningSecondView.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "screeningSecondView.h"
#import "SelectedTableViewCell.h"

#define WIDTH self.screeningCollectionView.frame.size.width

@implementation screeningSecondView

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/




- (void)awakeFromNib
{
    [super awakeFromNib];
    self.defaultDatasArray = [NSMutableArray array];
    for (int i=0; i<5; i++) {
        
        NSDictionary *defaultDict = @{@"typecode":@"",@"typename":@"全部"};
        [self.defaultDatasArray addObject:defaultDict];
    }
    [self uiConfigAction];
}


#pragma mark -获取数据
- (void)setDatasArray:(NSArray *)datasArray
{
    _datasArray = datasArray;
    [self resetCellselectedState];
    SelectedTableViewCell *cell = [self.screeningTableview cellForRowAtIndexPath:[NSIndexPath indexPathForRow:_selectedIndex inSection:0]];
    cell.titleLabe.backgroundColor = [UIColor whiteColor];
    cell.titleLabe.textColor = kMainBlueColor;
    
    
    [self.screeningCollectionView reloadData];
}


#pragma mark -取消cell的选中状态
- (void)resetCellselectedState
{
    NSArray *cellArray = [self.screeningTableview visibleCells];
    for (SelectedTableViewCell *CELL in cellArray) {
        CELL.titleLabe.backgroundColor = [UIColor grayColor];
        CELL.titleLabe.textColor = [UIColor whiteColor];
    }
}

#pragma mark - 布局
- (void)uiConfigAction
{
    self.screeningTableview.delegate = self;
    self.screeningTableview.dataSource = self;
    self.screeningTableview.tableFooterView = [UIView new];
    self.screeningTableview.separatorStyle = UITableViewCellSeparatorStyleNone;
    self.screeningTableview.backgroundColor = [UIColor grayColor];
    [self.screeningTableview registerClass:[SelectedTableViewCell class] forCellReuseIdentifier:@"tableviewcell"];
    self.screeningLayout.itemSize = CGSizeMake((WIDTH-127)/3, 35);
    self.screeningLayout.minimumLineSpacing = 30;
    self.screeningLayout.minimumInteritemSpacing = 10;
    self.screeningLayout.sectionInset = UIEdgeInsetsMake(20, 30, 20, 30);
    self.screeningResultButton.layer.masksToBounds = YES;
    self.screeningResultButton.layer.cornerRadius = kCornerRadius;
    [self.screeningCollectionView registerClass:[ScreeningFirstCollectionViewCell class] forCellWithReuseIdentifier:@"cell"];
    [self.screeningCollectionView registerClass:[ScreeningSecondCollectionReusableView class] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"screeningcell"];
    self.screeningCollectionView.dataSource = self;
    self.screeningCollectionView.delegate = self;
    self.screeningCollectionView.alwaysBounceVertical = YES;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    SelectedTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"tableviewcell" forIndexPath:indexPath];
    cell.titleLabe.text = [self.defaultDatasArray objectAtIndex_opple:indexPath.row][@"typename"];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.defaultDatasArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 55;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
   [self resetCellselectedState];
    SelectedTableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    cell.titleLabe.backgroundColor = [UIColor whiteColor];
    cell.titleLabe.textColor = kMainBlueColor;
    if ([self.delegate respondsToSelector:@selector(tableSelectedindex:)]) {
        
        [self.delegate tableSelectedindex:indexPath.row];
    }
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    ScreeningFirstCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"cell" forIndexPath:indexPath];
    cell.indexpath = indexPath;
    cell.delegate = self;
    if (self.selectedIndex == 1) {
        
        [cell.titleLabe setTitle:[[[[self.datasArray objectAtIndex_opple:indexPath.section] children] objectAtIndex_opple:indexPath.row] name] forState:UIControlStateNormal];
    }
    else
    {
        [cell.titleLabe setTitle:[[self.datasArray objectAtIndex_opple:indexPath.row] typeName] forState:UIControlStateNormal];
    }
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    if (self.selectedIndex == 1) {
        
        return [[[self.datasArray objectAtIndex_opple:section] children] count];
        
    }
    return self.datasArray.count;
}

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    if (self.selectedIndex == 1) {
       return self.datasArray.count;
    }
    return 1;
}


- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    
    ScreeningSecondCollectionReusableView *cell = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"screeningcell" forIndexPath:indexPath];
    [cell.alltitleButton addTarget:self action:@selector(AllButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    cell.clipsToBounds = YES;
    if (self.selectedIndex == 1) {

        NSString *subTitle = [[self.datasArray objectAtIndex_opple:indexPath.section] name];
        [cell.subTitleButton setTitle:subTitle forState:UIControlStateNormal];
        if (indexPath.section != 0) {
            [cell.alltitleButton setTitle:subTitle forState:UIControlStateNormal];
            cell.alltitleButton.layer.masksToBounds = NO;
            cell.alltitleButton.layer.borderWidth = 0;
            cell.alltitleButton.enabled = NO;
        }else
        {
            [cell.alltitleButton setTitle:@"全部" forState:UIControlStateNormal];
            cell.alltitleButton.layer.masksToBounds = YES;
            cell.alltitleButton.layer.borderWidth = 1;
            cell.alltitleButton.enabled = YES;
        }
    }else
    {
        [cell.alltitleButton setTitle:@"全部" forState:UIControlStateNormal];
        cell.alltitleButton.layer.masksToBounds = YES;
        cell.alltitleButton.layer.borderWidth = 1;
        cell.alltitleButton.enabled = YES;
    }
    return cell;
}


- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section{

    if (self.selectedIndex == 1 && section == 0) {

        return CGSizeMake(self.screeningCollectionView.frame.size.width, 130);
    }
    return CGSizeMake(self.screeningCollectionView.frame.size.width, 75);
}





#pragma mark -选中回调
- (void)SelectedButtonClickAction:(NSIndexPath *)indexpath
{
    //选中后的tableview赋值，并传递typecode筛选商品
    SelectedTableViewCell *cell = [self.screeningTableview cellForRowAtIndexPath:[NSIndexPath indexPathForRow:self.selectedIndex inSection:0]];
    //选中类型的文本
    NSString *selectedTitle = nil;
    //选中的key
    NSString *selectedTypecode = nil;
    
    //选中状态
//    ScreeningFirstCollectionViewCell *newCell = (ScreeningFirstCollectionViewCell *)[self.screeningCollectionView cellForItemAtIndexPath:indexpath];
//    newCell.titleLabe.selected = YES;
//    newCell.titleLabe.backgroundColor = kMainBlueColor;
    
    if (self.selectedIndex == 1) {
        
        selectedTitle = [[[[self.datasArray objectAtIndex_opple:indexpath.section] children] objectAtIndex_opple:indexpath.row] name];
        selectedTypecode = [[[[self.datasArray objectAtIndex_opple:indexpath.section] children] objectAtIndex_opple:indexpath.row] fid];
    }
    else
    {
        selectedTitle = [[self.datasArray objectAtIndex_opple:indexpath.row] typeName];
        selectedTypecode = [[self.datasArray objectAtIndex_opple:indexpath.row] typecode];
    }
    NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:selectedTitle,@"typename",selectedTypecode,@"typecode", nil];
    [self.defaultDatasArray replaceObjectAtIndex:self.selectedIndex withObject:dict];
    cell.titleLabe.text = selectedTitle;
    [self JudgeDelegateIsPerformWithPassParamater];
}






#pragma mark -区头的全部按钮点击
- (void)AllButtonClick:(UIButton *)button
{

    SelectedTableViewCell *cell = (SelectedTableViewCell *)[self.screeningTableview cellForRowAtIndexPath:[NSIndexPath indexPathForRow:self.selectedIndex inSection:0]];
    cell.titleLabe.text = @"全部";
    NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:button.currentTitle,@"typename", nil];
    [self.defaultDatasArray replaceObjectAtIndex:self.selectedIndex withObject:dict];
    [self JudgeDelegateIsPerformWithPassParamater];

}


#pragma mark -判断代理是否被执行，并传递复选的参数
- (void)JudgeDelegateIsPerformWithPassParamater
{
    if ([self.delegate respondsToSelector:@selector(collectionSelectedindexWithStyleCode:withCategories:withSpace:withMaterial:withPrice:)]) {
        
        //传回选中的所有条件
        [self.delegate collectionSelectedindexWithStyleCode:[self.defaultDatasArray objectAtIndex_opple:0][@"typecode"] withCategories:[self.defaultDatasArray objectAtIndex_opple:1][@"typecode"] withSpace:[self.defaultDatasArray objectAtIndex_opple:2][@"typecode"] withMaterial:[self.defaultDatasArray objectAtIndex_opple:3][@"typecode"] withPrice:[self.defaultDatasArray objectAtIndex_opple:4][@"typename"]];
    }
}


#pragma mark -筛选结果点击
- (IBAction)ScreeningResultButtonClick:(UIButton *)sender {
    
    if ([self.delegate respondsToSelector:@selector(ShowScreeningResponse)]) {
        
        [self.delegate ShowScreeningResponse];
    }
}



#pragma mark -传入满足搜索条件的个数
- (void)setTotalNumber:(NSInteger)totalNumber
{
    _totalNumber = totalNumber;
    [self.screeningResultButton setTitle:[NSString stringWithFormat:@"筛选结果共%ld件商品",totalNumber] forState:UIControlStateNormal];
     
}



















@end
