//
//  PaymentWithdrawalMainViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/29.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PaymentWithdrawalMainViewController.h"
#import "PaymentsViewController.h"
#import "WithdrawalViewController.h"

@interface PaymentWithdrawalMainViewController ()

/**
 指示线
 */
@property (weak, nonatomic) IBOutlet UIView *instructionView;

/**
 控制器背景
 */
@property (weak, nonatomic) IBOutlet UIView *controllerBackView;

/**
 *  当前的控制器
 */
@property (nonatomic,strong) BaseViewController *currentVC;

/**
 收支明细
 */
@property (weak, nonatomic) IBOutlet UIButton *paymentDetailsButton;

/**
 指示线x约束
 */
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *instructionViewConstraint;

/**
 提现进度
 */
@property (weak, nonatomic) IBOutlet UIButton *withdrawalButton;


@end

@implementation PaymentWithdrawalMainViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addChildViewController];
}

#pragma mark - 添加收支明细、提现进度控制器
- (void)addChildViewController
{
    PaymentsViewController *payments = [[[self class] getMainStoryboardClass]instantiateViewControllerWithIdentifier:@"PaymentsViewController"];
    [self addChildViewController:payments];
    WithdrawalViewController *withdrawal = [[[self class] getMainStoryboardClass]instantiateViewControllerWithIdentifier:@"WithdrawalViewController"];
    [self addChildViewController:withdrawal];
    [self.controllerBackView addSubview:payments.view];
    self.currentVC = payments;
}

#pragma mark - 布局
- (void)viewDidLayoutSubviews
{
    PaymentsViewController *payments = self.childViewControllers[0];
    payments.view.frame = CGRectMake(0, 0, self.controllerBackView.width, self.controllerBackView.height);

    WithdrawalViewController *withdrawal = self.childViewControllers[1];
    withdrawal.view.frame = CGRectMake(0, 0, self.controllerBackView.width, self.controllerBackView.height);
}

#pragma mark - 收支明细、提现进度
- (IBAction)paymentDetailsOrwithdrawalButtonClickAction:(UIButton *)sender {
    
    NSInteger number = sender.tag-100;
    switch (number) {
        case PaymentDetails:
        {
            self.withdrawalButton.selected = NO;
        }
            break;
        case Withdrawal:
        {
            self.paymentDetailsButton.selected = NO;
        }
            break;
            
        default:
            break;
    }
    sender.selected = YES;
    [self setupInstructionsViewOrigin:sender];
    [self switchPaymentsVCAndWithdrawalVC:self.childViewControllers[sender.tag-100]];
}


#pragma mark - 切换控制器
- (void)switchPaymentsVCAndWithdrawalVC:(BaseViewController *)newViewController
{
    [self transitionFromViewController:self.currentVC toViewController:newViewController duration:0.5 options:UIViewAnimationOptionTransitionNone animations:nil completion:^(BOOL finished) {
        if (finished) {
            [self.controllerBackView addSubview:newViewController.view];
            self.currentVC = newViewController;
        }
    }];
}

#pragma mark - 设置指示线的位置
- (void)setupInstructionsViewOrigin:(UIButton *)sender
{
    self.instructionViewConstraint.constant = sender.x+12;
    [UIView animateWithDuration:0.5 delay:0.1f usingSpringWithDamping:0.5f initialSpringVelocity:0.5f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        [self.view layoutIfNeeded];
    } completion:nil];
}




@end
