//
//  EmigratedFinishViewController.h
//  Lighting
//
//  Created by 曹云霄 on 2016/12/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"


@protocol CompeteDelegate <NSObject>

- (void)finish;

@end

/**
 闯关结果

 - NotThrough: 未通过
 - Through:    已通过
 - Audit:      待审核
 */
typedef NS_ENUM(NSInteger,RESULT_STATE){
    NotThrough = 0,
    Through,
    Audit
};

@interface EmigratedFinishViewController : BaseViewController
@property (nonatomic,weak) id<CompeteDelegate>delegate;
@property (nonatomic,assign) RESULT_STATE state;

/**
 闯关结果
 */
@property (weak, nonatomic) IBOutlet UILabel *emigratedResultLabel;

/**
 得分
 */
@property (nonatomic,copy) NSString *score;

/**
 积分
 */
@property (weak, nonatomic) IBOutlet UILabel *integralLabel;

/**
 积分
 */
@property (nonatomic,copy) NSString *integral;


@end
