//
//  VideoListItemTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "VideoListItemTableViewCell.h"

@implementation VideoListItemTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
    
    self.studyProgressView = [[PNCircleChart alloc]initWithFrame:CGRectMake(0, 0, 30, 30) total:@100 current:@0 clockwise:YES shadow:YES shadowColor:[UIColor lightGrayColor] displayCountingLabel:YES overrideLineWidth:@2];
    [self.studyProgressView setStrokeColor:[UIColor colorWithHue:0.00 saturation:0.50 brightness:0.93 alpha:1.00]];
    [self.studyProgressView strokeChart];
    self.studyProgressView.countingLabel.font = [UIFont systemFontOfSize:8];
    [self.seekbarView addSubview:self.studyProgressView];
}


- (void)setModel:(CustomStudyEntity *)model
{
    _model = model;
    self.studyItemTitleLabel.text = _model.title;
    self.studyItemTimeLabel.text = _model.videoLength;
    [self.studyProgressView updateChartByCurrent:@50];
}

@end
