//
//  VideoDetailViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "VideoDetailViewController.h"
#import "VideoDetailIntroTableViewCell.h"
#import "VideoLecturerTableViewCell.h"
#import "WkWebViewViewController.h"
#import "SpecifiedTableViewCell.h"


@interface VideoDetailViewController ()<UITableViewDataSource,UITableViewDelegate>


@end

@implementation VideoDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTableView];
}

#pragma mark - 选中学习内容下标
- (void)setIndexPath:(NSIndexPath *)indexPath
{
    _indexPath = indexPath;
    [self.studyItemDetailsTableView reloadData];
}

#pragma mark - UITableView
- (void)setUpTableView
{
    self.studyItemDetailsTableView.tableFooterView = [UIView new];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.row) {
        case StudyItemIntroCell:
        {
            VideoDetailIntroTableViewCell *itemDetailCell = [tableView dequeueReusableCellWithIdentifier:@"VideoDetailIntroTableViewCell" forIndexPath:indexPath];
            RsStudyTask *studyEntity = self.datasArray[self.indexPath.section];
            itemDetailCell.studyEntity = studyEntity.studyTasks[self.indexPath.row];
            return itemDetailCell;
        }
            break;
        case LecturerIntroCell:
        {
            VideoLecturerTableViewCell *lectureCell = [tableView dequeueReusableCellWithIdentifier:@"VideoLecturerTableViewCell" forIndexPath:indexPath];
            RsStudyTask *studyEntity = self.datasArray[self.indexPath.section];
            lectureCell.studyEntity = studyEntity.studyTasks[self.indexPath.row];
            return lectureCell;
        }
            break;
        case ContraposePersonCell:
        {
            SpecifiedTableViewCell *scopeCell = [tableView dequeueReusableCellWithIdentifier:@"SpecifiedTableViewCell" forIndexPath:indexPath];
            RsStudyTask *studyEntity = self.datasArray[self.indexPath.section];
            scopeCell.studyEntity = studyEntity.studyTasks[self.indexPath.row];
            return scopeCell;
        }
            break;
            
        default:
            break;
    }
    return nil;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    RsStudyTask *studyEntity = self.datasArray[self.indexPath.section];
    CustomStudyEntity *study = studyEntity.studyTasks[self.indexPath.row];
    switch (indexPath.row) {
        case StudyItemIntroCell:
            return study.contentHeight;
            break;
        case LecturerIntroCell:
            return study.teacherIntroHeight;
            break;
        case ContraposePersonCell:
            return 100;
            break;
            
        default:
            break;
    }
    return 0;
}








@end
