//
//  CustomStudyEntity.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/5.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomStudyEntity.h"
#import <AVFoundation/AVFoundation.h>
@implementation CustomStudyEntity


- (CGFloat)contentHeight
{
    if (!_contentHeight) {
        _contentHeight = [self calculateStudyIntroductionHeight:self.content]+74;
    }
    return _contentHeight;
}

- (CGFloat)teacherIntroHeight
{
    if (!_teacherIntroHeight) {
        _teacherIntroHeight = [self calculateStudyIntroductionHeight:self.teacherIntro]+106;
    }
    return _teacherIntroHeight;
}

- (NSString *)videoLength
{
    if (!_videoLength) {
        _videoLength = [self calculateVideoLength];
    }
    return _videoLength;
}

#pragma mark - 计算视频长度
- (NSString *)calculateVideoLength
{
    if ([self.attachment.fileUrl rangeOfString:@".mp4"].location != NSNotFound) {
        NSURL *movieURL = [NSURL URLWithString:self.attachment.fileUrl];
        NSDictionary *opts = [NSDictionary dictionaryWithObject:[NSNumber numberWithBool:NO]
                                                         forKey:AVURLAssetPreferPreciseDurationAndTimingKey];
        AVURLAsset *urlAsset = [AVURLAsset URLAssetWithURL:movieURL options:opts];  // 初始化视频媒体文件
        NSInteger interval = urlAsset.duration.value / urlAsset.duration.timescale; // 获取视频总时长,单位秒
        NSUInteger secondPerDay = 24 * 60 * 60;
        NSUInteger secondPerHour = 60 * 60;
        NSUInteger secondPerMinute = 60;
        
        // 剩余小时不应该大于24小时，所以应该先除去满足一天的秒数，再计算还剩下多少小时
        NSInteger hour = interval % secondPerDay / secondPerHour;
        // 剩余分钟数与上面同理
        NSInteger minute = interval % secondPerHour / secondPerMinute;
        // 剩余秒数直接等于秒数对每分钟秒数所取的余数
        NSInteger second = interval % secondPerMinute;
        NSMutableString *string = [NSMutableString string];
        if (hour) {
            [string appendString:[NSString stringWithFormat:@"%02zd:",hour]];
        }
        [string appendString:[NSString stringWithFormat:@"%02zd:%02zd",minute,second]];
        return string;
        }
    return nil;
}


#pragma mark - 计算高度
- (CGFloat)calculateStudyIntroductionHeight:(NSString *)content
{
    return  [content heightWithFontSize:13 width:ScreenWidth*2/3-28*2];
}



@end
