//
//  ForumItemTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ForumItemTableViewCell.h"

@implementation ForumItemTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
    self.isElitePostLabel.customText = @"精华帖";
    self.placedLabel.customText = @"置顶";
}

- (void)setTopicEntity:(CustomTOForumTopicEntity *)topicEntity
{
    _topicEntity = topicEntity;
    if (_topicEntity) {
        self.isElitePostLabel.hidden = !_topicEntity.bestTopic;
        self.placedLabel.hidden = !_topicEntity.bestTopic;
        self.titleLabelConstraint.constant = _topicEntity.bestTopic?10:-110;
        self.titleLabel.text = _topicEntity.title;
        self.contentLabel.text = _topicEntity.content;
        self.nameAndDateLabel.text = [NSString stringWithFormat:@"%@:  %@  %@",_topicEntity.posterPosition,_topicEntity.posterRealName,_topicEntity.postTime];
        self.commentsNumberLabel.text = [NSString stringWithFormat:@"%ld",_topicEntity.replyCount];
        self.praiseNumberLabel.text = [NSString stringWithFormat:@"%ld",_topicEntity.likeCount];
        self.imageBackView.hidden = _topicEntity.attachments.count?NO:YES;
        if (_topicEntity.attachments.count) {
            self.imageBackView.imageArray = _topicEntity.attachments;
        }
        self.imageBackView.indexPath = self.indexPath;
    }
}

@end
