//
//  ForumItemListViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ForumItemListViewController.h"
#import "ForumItemTableViewCell.h"
#import "ReleasePostViewController.h"
#import "ForumItemDetailViewController.h"
#import "MWPhotoBrowser.h"

@interface ForumItemListViewController ()<UITableViewDelegate,UITableViewDataSource,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate,TapClickImageViewDelegate,MWPhotoBrowserDelegate>

@property (nonatomic,strong) ForumTopicCondition *condition;
@property (nonatomic,strong) NSMutableArray *datasArray;

/**
 图片数组
 */
@property (nonatomic,strong) NSMutableArray *selecteImageArray;
@end

@implementation ForumItemListViewController

#pragma mark - lazy
- (ForumTopicCondition *)condition
{
    if (!_condition) {
        _condition = [[ForumTopicCondition alloc] init];
        DataPage *page = [[DataPage alloc] init];
        page.page = ZERO;
        page.rows = KROWS;
        _condition.categoryEquals = self.category.fid;
        _condition.page = page;
    }
    return _condition;
}

- (NSMutableArray *)datasArray
{
    if (!_datasArray) {
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}

- (NSMutableArray *)selecteImageArray
{
    if (!_selecteImageArray) {
        _selecteImageArray = [NSMutableArray array];
    }
    return _selecteImageArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpRefreshAction];
    [self uiConfigAction];
}

#pragma mark - 设置刷新
- (void)setUpRefreshAction
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        weakSelf.condition.page.page = ONE;
        [weakSelf.classificationListTableView.mj_footer resetNoMoreData];
        [weakSelf getClassificationList:weakSelf.condition isRemoveArray:YES];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.classificationListTableView.mj_header =headerRefresh;
    [self.classificationListTableView.mj_header beginRefreshing];
    self.classificationListTableView.mj_footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (++ weakSelf.condition.page.page > weakSelf.condition.page.total) {
            [weakSelf.classificationListTableView.mj_footer endRefreshingWithNoMoreData];
        }else
        {
            [weakSelf getClassificationList:weakSelf.condition isRemoveArray:NO];
        }
    }];
    self.classificationListTableView.mj_footer.automaticallyHidden = YES;
}

#pragma mark - UI
- (void)uiConfigAction
{
    self.classifyTitleLabel.text = self.category.name;
    [self.classifyImageView sd_setImageWithURL:[NSURL URLWithString:self.category.attachment.fileUrl] placeholderImage:REPLACEIMAGE];
    self.classifyListCountLabel.text = [NSString stringWithFormat:@"%ld",self.category.topicCount];
}

#pragma mark - 获取分类帖子列表
- (void)getClassificationList:(ForumTopicCondition *)condtion isRemoveArray:(BOOL)remove
{
    [XBLoadingView showHUDViewWithDefault];
    WS(weakSelf);
    NSLog(@"%@",[[condtion toDictionary] JSONString]);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(QUERTFORUMLIST) WithRequestType:ZERO WithParameter:condtion WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        [weakSelf endRefreshingForTableView:weakSelf.classificationListTableView];
        weakSelf.classificationListTableView.emptyDataSetSource = weakSelf;
        weakSelf.classificationListTableView.emptyDataSetDelegate = weakSelf;
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            if (remove) {
                [weakSelf.datasArray removeAllObjects];
            }
            ForumTopicResponse *result = [[ForumTopicResponse alloc] initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf.datasArray addObjectsFromArray:result.forumTopicEntity];
        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        [weakSelf.classificationListTableView reloadData];
    } WithFailureBlock:^(NSError *error) {
        [XBLoadingView hideHUDViewWithDefault];
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 发帖
- (IBAction)releaseButtonClickAction:(UIButton *)sender {
    
    ReleasePostViewController *releaseVc = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"ReleasePostViewController"];
    releaseVc.category = self.category;
    WS(weakSelf);
    [releaseVc setFinishBlock:^{
        [weakSelf.classificationListTableView.mj_header beginRefreshing];
    }];
    [self.navigationController pushViewController:releaseVc animated:YES];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ForumItemTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ForumItemTableViewCell" forIndexPath:indexPath];
    cell.indexPath = indexPath;
    cell.topicEntity = self.datasArray[indexPath.row];
    cell.imageBackView.delegate = self;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.datasArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CustomTOForumTopicEntity *entity = self.datasArray[indexPath.row];
    //10 表示控件间隙、60 表示content  Y  150 表示图片背景框高度
    CGFloat height = entity.contentHeight + 60 + 20;
    if (entity.attachments.count) {
        height += 150+10;
    }
    return height;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ForumItemDetailViewController *postDetail = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"ForumItemDetailViewController"];
    postDetail.topicDetail = self.datasArray[indexPath.row];
    WS(weakSelf);
    //删除帖子
    [postDetail setDelectBlock:^(NSString *topicId) {
        for (int i=0; i<weakSelf.datasArray.count; i++) {
            CustomTOForumTopicEntity *entity = self.datasArray[i];
            if ([entity.fid isEqualToString:topicId]) {
                [weakSelf.classificationListTableView beginUpdates];
                [weakSelf.datasArray removeObjectAtIndex:i];
                [weakSelf.classificationListTableView deleteRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:i inSection:ZERO]] withRowAnimation:UITableViewRowAnimationLeft];
                [weakSelf.classificationListTableView endUpdates];
            }
        }
    }];
    [self.navigationController pushViewController:postDetail animated:YES];
}

#pragma mark - 单击查看大图<TapClickImageViewDelegate>
- (void)tapImageViewWithIndex:(NSInteger)index withCellIndex:(NSIndexPath *)indexPath
{
    [self.selecteImageArray removeAllObjects];
    CustomTOForumTopicEntity *topicEntity = self.datasArray[indexPath.row];
    for (TOAttachmentEntity *entity in topicEntity.attachments) {
        MWPhoto *photo = [MWPhoto photoWithURL:[NSURL URLWithString:entity.fileUrl]];
        [self.selecteImageArray addObject:photo];
    }
    MWPhotoBrowser *browser = [[MWPhotoBrowser alloc] initWithDelegate:self];
    [browser setCurrentPhotoIndex:index];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:browser];
    [self.navigationController presentViewController:nav animated:YES completion:nil];
}

#pragma mark - <MWPhotoBrowserDelegate>
- (NSUInteger)numberOfPhotosInPhotoBrowser:(MWPhotoBrowser *)photoBrowser {
    return self.selecteImageArray.count;
}

- (id <MWPhoto>)photoBrowser:(MWPhotoBrowser *)photoBrowser photoAtIndex:(NSUInteger)index {
    if (index < self.selecteImageArray.count)
        return [self.selecteImageArray objectAtIndex:index];
    return nil;
}


#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}

@end
