
#import <Foundation/Foundation.h>
#import "JSONModel.h"

#ifndef DEF_SortDirection_H
#define DEF_SortDirection_H

/**
 *  @Description: TODO(排序定义)
 *  asc 升序
 *  @author  张代浩
 *  desc 降序
 */
/**
 *
 */
extern NSString * const SORTDIRECTION_ASC;
/**
 *
 */
extern NSString * const SORTDIRECTION_DESC;

#endif /* DEF_SortDirection_H */


@class PageRows;
@class RsResponse;
@class LoginInfo;
@class ModifyPasswordRequest;
@class DataDict;
@class GoodsCondition;
@class GoodsFilter;
@class OrderBill;
@class SceneCondition;
@class SceneFilter;
@class TOConsumerEntity;
@class TOGoodsBrandEntity;
@class TOGoodsLabelEntity;
@class TOHottagEntity;
@class TOOrderdetailEntity;
@class TOSceneEntity;
@class TOShopcartEntity;
@class IdEntity;
@class TOShippingAddrEntity;
@class TOPositionEntity;
@class TOOrderEntity;
@class TOGoodsLabelCategoryEntity;
@class TOGoodsCategoryEntity;
@class TOGoodsEntity;
@class HotTagResponse;
@class GoodsCategory;
@class ResetPasswordRequest;
@class LoginResult;
@class ConsumerQueryCondition;
@class ExceptionCode;
@class DataPage;
@class SceneResponse;
@class TSBaseUser;
@class TSDepart;
@class TSUserOrg;
@class ShopCartResponse;
@class OrderResponse;
@class GoodsResponse;
@class ConsumerPageResult;
@class TSUser;
@class TOEmployee;

@protocol PageRows @end
@protocol RsResponse @end
@protocol LoginInfo @end
@protocol ModifyPasswordRequest @end
@protocol DataDict @end
@protocol GoodsCondition @end
@protocol GoodsFilter @end
@protocol OrderBill @end
@protocol SceneCondition @end
@protocol SceneFilter @end
@protocol TOConsumerEntity @end
@protocol TOGoodsBrandEntity @end
@protocol TOGoodsLabelEntity @end
@protocol TOHottagEntity @end
@protocol TOOrderdetailEntity @end
@protocol TOSceneEntity @end
@protocol TOShopcartEntity @end
@protocol IdEntity @end
@protocol TOShippingAddrEntity @end
@protocol TOPositionEntity @end
@protocol TOOrderEntity @end
@protocol TOGoodsLabelCategoryEntity @end
@protocol TOGoodsCategoryEntity @end
@protocol TOGoodsEntity @end
@protocol HotTagResponse @end
@protocol GoodsCategory @end
@protocol ResetPasswordRequest @end
@protocol LoginResult @end
@protocol ConsumerQueryCondition @end
@protocol ExceptionCode @end
@protocol DataPage @end
@protocol SceneResponse @end
@protocol TSBaseUser @end
@protocol TSDepart @end
@protocol TSUserOrg @end
@protocol ShopCartResponse @end
@protocol OrderResponse @end
@protocol GoodsResponse @end
@protocol ConsumerPageResult @end
@protocol TSUser @end
@protocol TOEmployee @end


#ifndef DEF_PageRows_H
#define DEF_PageRows_H

/**
 *  分页类
 
 @author Administrator
 @since 0.1
 
 */
@interface PageRows : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) int page;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) int rows;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) int total;
@end /* interface PageRows */

#endif


#ifndef DEF_RsResponse_H
#define DEF_RsResponse_H

/**
 *  Restful Service response base
 
 @author Debenson
 @since 0.1
 
 */
@interface RsResponse : JSONModel
/**
 * 0:正常， 非0异常。
 *
 *
 */
@property (nonatomic, assign) long long code;
/**
 * 异常描述
 *
 *
 */
@property (nonatomic, copy) NSString *message;
/**
 * 返回数据
 *
 *
 */
@property (nonatomic, strong) NSObject *data;
@end /* interface RsResponse */

#endif


#ifndef DEF_LoginInfo_H
#define DEF_LoginInfo_H

/**
 *  经销商用户登录信息。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginInfo : JSONModel
/**
 * 用户名
 *
 *
 */
@property (nonatomic, copy) NSString *username;
/**
 * 密码
 *
 *
 */
@property (nonatomic, copy) NSString *password;
@end /* interface LoginInfo */

#endif


#ifndef DEF_ModifyPasswordRequest_H
#define DEF_ModifyPasswordRequest_H

/**
 *  修改密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ModifyPasswordRequest : JSONModel
/**
 * 员工标识。
 *
 *
 */
@property (nonatomic, copy) NSString *employeeId;
/**
 * 原密码。
 *
 *
 */
@property (nonatomic, copy) NSString *oldPassword;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ModifyPasswordRequest */

#endif


#ifndef DEF_DataDict_H
#define DEF_DataDict_H

/**
 *  @author Administrator
 @since 0.1
 
 */
@interface DataDict : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *typename;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *typecode;
@end /* interface DataDict */

#endif


#ifndef DEF_GoodsCondition_H
#define DEF_GoodsCondition_H

/**
 *  @author NuoSa
 
 @since 0.1
 
 */
@interface GoodsCondition : JSONModel
/**
 * 查询条件是 商品名称
 *
 *
 */
@property (nonatomic, copy) NSString *nameLike;
/**
 * 查询条件是 类型id，取值: GoodsCategory#getId()
 *
 *
 */
@property (nonatomic, copy) NSString *categoryEquals;
/**
 * 查询条件是 风格
 *
 *
 */
@property (nonatomic, copy) NSString *styleEquals;
/**
 * 查询条件是 空间
 *
 *
 */
@property (nonatomic, copy) NSString *spaceEquals;
/**
 * 查询条件是 材质
 *
 *
 */
@property (nonatomic, copy) NSString *materialEqueals;
/**
 * 查询条件是 起始价格
 *
 *
 */
@property (nonatomic, strong) NSNumber *startprice;
/**
 * 查询条件是 起始价格
 *
 *
 */
@property (nonatomic, strong) NSNumber *endprice;
/**
 * 分页
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface GoodsCondition */

#endif


#ifndef DEF_GoodsFilter_H
#define DEF_GoodsFilter_H

/**
 *  @author Debenson
 @since 0.1
 
 */
@interface GoodsFilter : JSONModel
/**
 * 风格
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *styles;
/**
 * (no documentation provided)
 * @see GoodsCategory
 *
 */
@property (nonatomic, strong) NSArray<GoodsCategory> *categories;
/**
 * 空间
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *space;
/**
 * 材质
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *material;
/**
 * 价格
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *price;
@end /* interface GoodsFilter */

#endif


#ifndef DEF_OrderBill_H
#define DEF_OrderBill_H

/**
 *  @author Flash
 @since 0.1
 
 */
@interface OrderBill : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *datapage;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOOrderEntity *order;
/**
 * (no documentation provided)
 * @see TOOrderdetailEntity
 *
 */
@property (nonatomic, strong) NSArray<TOOrderdetailEntity> *orderdetailList;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOConsumerEntity *consumer;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOEmployee *employee;
@end /* interface OrderBill */

#endif


#ifndef DEF_SceneCondition_H
#define DEF_SceneCondition_H

/**
 *  @author Administrator
 @since 0.1
 
 */
@interface SceneCondition : JSONModel
/**
 * 查询条件:风格
 *
 *
 */
@property (nonatomic, copy) NSString *styleEquals;
/**
 * 查询条件:空间
 *
 *
 */
@property (nonatomic, copy) NSString *spaceEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface SceneCondition */

#endif


#ifndef DEF_SceneFilter_H
#define DEF_SceneFilter_H

/**
 *  @author Administrator
 @since 0.1
 
 */
@interface SceneFilter : JSONModel
/**
 * (no documentation provided)
 * @see NSString
 *
 */
@property (nonatomic, strong) NSArray *styles;
/**
 * (no documentation provided)
 * @see NSString
 *
 */
@property (nonatomic, strong) NSArray *space;
@end /* interface SceneFilter */

#endif


#ifndef DEF_TOConsumerEntity_H
#define DEF_TOConsumerEntity_H

/**
 *  @Title: Entity
 @Description: 客户
 @author onlineGenerator
 @date 2016-05-08 18:08:58
 @version V1.0
 
 
 */
@interface TOConsumerEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *city;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *country;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *picture;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *lastVisitedTime;
@end /* interface TOConsumerEntity */

#endif


#ifndef DEF_TOGoodsBrandEntity_H
#define DEF_TOGoodsBrandEntity_H

/**
 *  @Title: Entity
 @Description: 商品品牌
 @author onlineGenerator
 @date 2016-05-05 16:14:51
 @version V1.0
 
 
 */
@interface TOGoodsBrandEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) int state;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *logo;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
@end /* interface TOGoodsBrandEntity */

#endif


#ifndef DEF_TOGoodsLabelEntity_H
#define DEF_TOGoodsLabelEntity_H

/**
 *  @Title: Entity
 @Description: 商品标签
 @author onlineGenerator
 @date 2016-05-05 17:18:15
 @version V1.0
 
 
 */
@interface TOGoodsLabelEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *categoryId;
@end /* interface TOGoodsLabelEntity */

#endif


#ifndef DEF_TOHottagEntity_H
#define DEF_TOHottagEntity_H

/**
 *  @Title: Entity
 @Description: 热门推荐
 @author onlineGenerator
 @date 2016-05-06 16:36:36
 @version V1.0
 
 
 */
@interface TOHottagEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface TOHottagEntity */

#endif


#ifndef DEF_TOOrderdetailEntity_H
#define DEF_TOOrderdetailEntity_H

/**
 *  @Title: Entity
 @Description: 订单详情
 @author onlineGenerator
 @date 2016-05-06 12:53:09
 @version V1.0
 
 
 */
@interface TOOrderdetailEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsCover;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsSpec;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsBrand;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsNum;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *goodsPrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *goodsTotalPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
@end /* interface TOOrderdetailEntity */

#endif


#ifndef DEF_TOSceneEntity_H
#define DEF_TOSceneEntity_H

/**
 *  @Title: Entity
 @Description: 场景
 @author onlineGenerator
 @date 2016-05-05 18:39:39
 @version V1.0
 
 
 */
@interface TOSceneEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sceneCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pricure;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *category;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *style;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *space;
@end /* interface TOSceneEntity */

#endif


#ifndef DEF_TOShopcartEntity_H
#define DEF_TOShopcartEntity_H

/**
 *
 @Title: Entity
 @Description: 购物车
 @author onlineGenerator
 @date 2016-05-05 16:13:38
 @version V1.0
 
 
 */
@interface TOShopcartEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsCover;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsSpec;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsBrand;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *goodsSellerPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsNum;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *goodsPrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *goodsTotalPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
@end /* interface TOShopcartEntity */

#endif


#ifndef DEF_IdEntity_H
#define DEF_IdEntity_H

/**
 * (no documentation provided)
 */
@interface IdEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
@end /* interface IdEntity */

#endif


#ifndef DEF_TOShippingAddrEntity_H
#define DEF_TOShippingAddrEntity_H

/**
 *
 @Title: Entity
 @Description: 收货地址
 @author onlineGenerator
 @date 2016-05-05 14:42:23
 @version V1.0
 
 
 */
@interface TOShippingAddrEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *miblephone;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *city;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *country;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) int state;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
@end /* interface TOShippingAddrEntity */

#endif


#ifndef DEF_TOPositionEntity_H
#define DEF_TOPositionEntity_H

/**
 *  @Title: Entity
 @Description: 经销商员工职位
 @author onlineGenerator
 @date 2016-05-02 17:39:21
 @version V1.0
 
 
 */
@interface TOPositionEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *commission;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerCode;
@end /* interface TOPositionEntity */

#endif


#ifndef DEF_TOOrderEntity_H
#define DEF_TOOrderEntity_H

/**
 *  @Title: Entity
 @Description: 订单
 @author onlineGenerator
 @date 2016-05-06 12:53:09
 @version V1.0
 
 
 */
@interface TOOrderEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *orderTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *guideId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderState;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsNum;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *orderPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *receiverName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *receiverMobile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *receiverAddress;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isBill;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billType;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billTitle;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *payType;
@end /* interface TOOrderEntity */

#endif


#ifndef DEF_TOGoodsLabelCategoryEntity_H
#define DEF_TOGoodsLabelCategoryEntity_H

/**
 *  @Title: Entity
 @Description: 商品标签分类
 @author onlineGenerator
 @date 2016-05-05 16:57:27
 @version V1.0
 
 
 */
@interface TOGoodsLabelCategoryEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface TOGoodsLabelCategoryEntity */

#endif


#ifndef DEF_TOGoodsCategoryEntity_H
#define DEF_TOGoodsCategoryEntity_H

/**
 *  @Title: Entity
 @Description: 商品分类
 @author onlineGenerator
 @date 2016-05-10 10:17:53
 @version V1.0
 
 
 */
@interface TOGoodsCategoryEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *upperId;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) int level;
@end /* interface TOGoodsCategoryEntity */

#endif


#ifndef DEF_TOGoodsEntity_H
#define DEF_TOGoodsEntity_H

/**
 *  @Title: Entity
 @Description: 商品
 @author onlineGenerator
 @date 2016-05-09 16:14:26
 @version V1.0
 
 
 */
@interface TOGoodsEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *createDate;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *onlineTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *company;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *number;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *categoryId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *brandId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *keyword;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *guidePrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *tagPrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *costPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *inv;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *detailedIntro;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *weight;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *unit;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productProfile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *power;
/**
 * 方法: ���得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *colorTemperature;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *spec;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *function;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *material;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightSource;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsStyle;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *series;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *area;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *size;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *space;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *installMethod;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pictures;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *barcode;
@end /* interface TOGoodsEntity */

#endif


#ifndef DEF_HotTagResponse_H
#define DEF_HotTagResponse_H

/**
 *  @author Administrator
 @since 0.1
 
 */
@interface HotTagResponse : JSONModel
/**
 * (no documentation provided)
 * @see TOHottagEntity
 *
 */
@property (nonatomic, strong) NSArray<TOHottagEntity> *list;
@end /* interface HotTagResponse */

#endif


#ifndef DEF_GoodsCategory_H
#define DEF_GoodsCategory_H

/**
 *  @author Debenson
 @since 0.1
 
 */
@interface GoodsCategory : JSONModel
/**
 * 分类id
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 分类名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 下级分类列表
 * @see GoodsCategory
 *
 */
@property (nonatomic, strong) NSArray<GoodsCategory> *children;
@end /* interface GoodsCategory */

#endif


#ifndef DEF_ResetPasswordRequest_H
#define DEF_ResetPasswordRequest_H

/**
 *  重置密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ResetPasswordRequest : JSONModel
/**
 * 用户名
 *
 *
 */
@property (nonatomic, copy) NSString *username;
/**
 * 短信验证码，请先调用发送短信接口
 * com.gomore.opple.rest.system.RsSystemService#sendSms(String)
 *
 *
 */
@property (nonatomic, copy) NSString *smsCode;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ResetPasswordRequest */

#endif


#ifndef DEF_LoginResult_H
#define DEF_LoginResult_H

/**
 *  登录结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginResult : JSONModel
/**
 * 员工
 *
 *
 */
@property (nonatomic, strong) TOEmployee *employee;
/**
 * 分成比例
 *
 *
 */
@property (nonatomic, strong) NSNumber *commission;
@end /* interface LoginResult */

#endif


#ifndef DEF_ConsumerQueryCondition_H
#define DEF_ConsumerQueryCondition_H

/**
 *  客户查询条件。
 
 @author Debenson
 @since 0.1
 
 */
@interface ConsumerQueryCondition : JSONModel
/**
 * 名称等于
 *
 *
 */
@property (nonatomic, copy) NSString *nameEquals;
/**
 * 手机号等于
 *
 *
 */
@property (nonatomic, copy) NSString *mobileEquals;
/**
 * 分布查询条件， 可空
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface ConsumerQueryCondition */

#endif


#ifndef DEF_ExceptionCode_H
#define DEF_ExceptionCode_H

/**
 *  异常代码。
 
 @author Debenson
 @since 0.1
 
 */
@interface ExceptionCode : JSONModel
/**
 * 异常代码
 *
 *
 */
@property (nonatomic, assign) int code;
/**
 * 异常信息
 *
 *
 */
@property (nonatomic, copy) NSString *message;
@end /* interface ExceptionCode */

#endif


#ifndef DEF_DataPage_H
#define DEF_DataPage_H

/**
 *  easyui的datagrid向后台传递参数使用的model
 
 @author
 
 
 */
@interface DataPage : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) int total;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) int page;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) int rows;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *sort;
/**
 * (no documentation provided)
 *
 * 取值: SORTDIRECTION_ASC, SORTDIRECTION_DESC,
 */
@property (nonatomic, copy) NSString *order;
@end /* interface DataPage */

#endif


#ifndef DEF_SceneResponse_H
#define DEF_SceneResponse_H

/**
 *  @author Administrator
 @since 0.1
 
 */
@interface SceneResponse : PageRows
/**
 * (no documentation provided)
 * @see TOSceneEntity
 *
 */
@property (nonatomic, strong) NSArray<TOSceneEntity> *list;
@end /* interface SceneResponse */

#endif


#ifndef DEF_TSBaseUser_H
#define DEF_TSBaseUser_H

/**
 *  系统用户父类表
 @author  张代浩
 
 */
@interface TSBaseUser : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSData *signature;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *browser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userKey;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short status;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short activitiSync;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *realName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *currentDepart;
/**
 * (no documentation provided)
 * @see TSUserOrg
 *
 */
@property (nonatomic, strong) NSArray<TSUserOrg> *userOrgList;
@end /* interface TSBaseUser */

#endif


#ifndef DEF_TSDepart_H
#define DEF_TSDepart_H

/**
 *  部门机构表
 @author  张代浩
 
 */
@interface TSDepart : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *TSPDepart;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departname;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
/**
 * (no documentation provided)
 * @see TSDepart
 *
 */
@property (nonatomic, strong) NSArray<TSDepart> *TSDeparts;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgCode;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fax;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *address;
@end /* interface TSDepart */

#endif


#ifndef DEF_TSUserOrg_H
#define DEF_TSUserOrg_H

/**
 *  用户-组织机构 实体
 <p/>
 <p><b>User:</b> zhanggm <a href="mailto:guomingzhang2008@gmail.com">guomingzhang2008@gmail.com</a></p>
 <p><b>Date:</b> 2014-08-22 15:39</p>
 
 @author 张国明
 
 */
@interface TSUserOrg : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSUser *tsUser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *tsDepart;
@end /* interface TSUserOrg */

#endif


#ifndef DEF_ShopCartResponse_H
#define DEF_ShopCartResponse_H

/**
 *  购物车返回对象
 
 @author Flash
 @since 0.1
 
 */
@interface ShopCartResponse : PageRows
/**
 * (no documentation provided)
 * @see TOShopcartEntity
 *
 */
@property (nonatomic, strong) NSArray<TOShopcartEntity> *shopcart;
@end /* interface ShopCartResponse */

#endif


#ifndef DEF_OrderResponse_H
#define DEF_OrderResponse_H

/**
 *  订单返回对象
 
 @author wsx
 @since 0.1
 
 */
@interface OrderResponse : PageRows
/**
 * (no documentation provided)
 * @see OrderBill
 *
 */
@property (nonatomic, strong) NSArray<OrderBill> *orderBillList;
@end /* interface OrderResponse */

#endif


#ifndef DEF_GoodsResponse_H
#define DEF_GoodsResponse_H

/**
 *  @author NuoSa
 
 @since 0.1
 
 */
@interface GoodsResponse : PageRows
/**
 * 商品列表
 * @see TOGoodsEntity
 *
 */
@property (nonatomic, strong) NSArray<TOGoodsEntity> *goodsEntity;
@end /* interface GoodsResponse */

#endif


#ifndef DEF_ConsumerPageResult_H
#define DEF_ConsumerPageResult_H

/**
 *  客户分页查询结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface ConsumerPageResult : PageRows
/**
 * 客户列表
 * @see TOConsumerEntity
 *
 */
@property (nonatomic, strong) NSArray<TOConsumerEntity> *results;
@end /* interface ConsumerPageResult */

#endif


#ifndef DEF_TSUser_H
#define DEF_TSUser_H

/**
 *  系统用户表
 @author  张代浩
 
 */
@interface TSUser : TSBaseUser
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *signatureFile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobilePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *officePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, strong) NSDate *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
@end /* interface TSUser */

#endif


#ifndef DEF_TOEmployee_H
#define DEF_TOEmployee_H

/**
 *  经销商员工。
 
 @author Debenson
 @since 0.1
 
 */
@interface TOEmployee : TSUser
/**
 * 职位编码列表， (多个职位编码用逗号分隔，非必填)
 *
 *
 */
@property (nonatomic, copy) NSString *positions;
@end /* interface TOEmployee */

#endif

